<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="addonModalLabel">
                <?php echo Labels::getLabel('LBL_Available_Pickup_Locations', $siteLangId); ?></h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

            </button>
        </div>
        <div class="modal-body">
            <?php if (!empty($addresses)) { ?>
                <ul class="my-addresses">
                    <?php foreach ($addresses as $address) { ?>
                        <li class="my-addresses-item">
                            <div class="my-addresses-body">
                                <address class="delivery-address">
                                    <h5><?php echo $address['addr_name']; ?><span
                                            class="tag"><?php echo $address['addr_title']; ?></span></h5>
                                    <p>
                                        <?php echo $address['addr_address1'] . '<br>'; ?>
                                        <?php echo (strlen($address['addr_address2']) > 0) ? $address['addr_address2'] . '<br>' : ''; ?>
                                        <?php echo (strlen($address['addr_city']) > 0) ? $address['addr_city'] . ',' : ''; ?>
                                        <?php echo (strlen($address['state_name']) > 0) ? $address['state_name'] . '<br>' : ''; ?>
                                        <?php echo (strlen($address['country_name']) > 0) ? $address['country_name'] . '<br>' : ''; ?>
                                        <?php echo (strlen($address['addr_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $siteLangId) . ' ' . $address['addr_zip'] . '<br>' : ''; ?>
                                    </p>
                                    <p class="phone-txt">
                                        <svg class="svg" width="16" height="16">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                            </use>
                                        </svg>
                                        <?php echo (strlen($address['addr_phone']) > 0) ? Labels::getLabel('LBL_Phone:', $siteLangId) . ' ' . $address['addr_dial_code'] . ' ' . $address['addr_phone'] . '<br>' : ''; ?>
                                    </p>
                                </address>
                            </div>
                        </li>
                    <?php } ?>
                </ul>
            <?php } else { ?>
                <p class="text-center"><?php echo Labels::getLabel('LBL_Pickup_Address_Not_Added', $siteLangId); ?></p>
            <?php } ?>
        </div>
    </div>
</div>