<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$displayProductNotAvailableLable = false;
if (trim(FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '')) != '') {
    $displayProductNotAvailableLable = true;
}

$selectedFullfillmentType = (isset($_COOKIE['locationCheckoutType'])) ? FatUtility::int($_COOKIE['locationCheckoutType']) : Shipping::FULFILMENT_SHIP;

$activeRentalDurations = applicationConstants::getActiveRentalDurations();
$rentalTypeArr = applicationConstants::rentalTypeArr($siteLangId);
?>
<main id="body" class="body">
    <section class="section" data-collection="collection-name">
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-md-3">
                    <div class="product-profile product-profile-free-size mb-2">

                        <a class="product-profile-thumbnail" title="<?php echo $product['selprod_title']; ?>"
                            href="<?php echo UrlHelper::generateUrl('products', 'view', array($product['selprod_id'])); ?>">
                            <img width="300" alt="<?php echo $product['selprod_title']; ?>"
                                src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($product['product_id'], "SMALL", $product['selprod_id'], 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg'); ?>">
                        </a>


                        <div class="product-profile-data">

                            <a class="title" title="<?php echo $product['selprod_title']; ?>"
                                href="<?php echo UrlHelper::generateUrl('products', 'view', array($product['selprod_id'])); ?>">
                                <?php echo $product['selprod_title']; ?>
                            </a>

                            <?php if (round($product['prod_rating']) > 0 && FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) { ?>
                                <div class="products__rating">
                                    <svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#star-yellow">
                                        </use>
                                    </svg>

                                    <span class="rate">
                                        <?php echo round($product['prod_rating'], 1); ?>
                                    </span>
                                </div>
                            <?php } ?>

                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <h4 class="h4 mb-3">
                        <strong>
                            <?php echo Labels::getLabel('LBL_Compare_price_with_other_Sellers', $siteLangId); ?>
                        </strong>
                    </h4>
                    <div class="scroll scroll-x js-scrollable table-wrap">
                        <?php
                        $arr_flds = array(
                            'shop_name' => Labels::getLabel('LBL_Seller', $siteLangId),
                            'rent_price' => Labels::getLabel('LBL_Rental_Price', $siteLangId),
                        );
						
						if (ALLOW_SALE) {
							$arr_flds['selprod_price'] = Labels::getLabel('LBL_Selling_Price', $siteLangId);
						}
						
						$arr_flds['COD'] = Labels::getLabel('LBL_COD_AVAILABLE', $siteLangId);
						$arr_flds['Action'] = '';
						
                        $tbl = new HtmlElement('table', array('class' => 'table table-justified'));
                        $th = $tbl->appendElement('thead')->appendElement('tr', array('class' => ''));
                        foreach ($arr_flds as $val) {
                            $e = $th->appendElement('th', array(), $val);
                        }

                        $sr_no = 0;
                        //echo "<pre>"; print_r($product['moreSellersArr']); echo "</pre>"; exit;
                        
                        foreach ($product['moreSellersArr'] as $sn => $moresellers) {
                            $sr_no++;
                            $tr = $tbl->appendElement('tr', array('class' => ''));
                            foreach ($arr_flds as $key => $val) {
                                $td = $tr->appendElement('td');
                                switch ($key) {
                                    case 'shop_name':
                                        $labelTxt = ($selectedFullfillmentType == Shipping::FULFILMENT_PICKUP) ? Labels::getLabel('LBL_Check_Pickup_Locations', $siteLangId) : Labels::getLabel('LBL_Calculate_Shipping_Charges', $siteLangId);
                                        $locationAction = '<button type="button" class="link-brand link-underline" onClick="getFullfillmentData(' . $selectedFullfillmentType . ', ' . applicationConstants::PRODUCT_FOR_RENT . ', ' . $product['selprod_id'] . ')">' . $labelTxt . '</button> ';


                                        $txt = '<div class="shop-profile">
                                <figure class="shop-profile-thumbnail">
                                    <a title="' . $moresellers[$key] . '" href="' . UrlHelper::generateUrl('shops', 'view', array($moresellers['shop_id'])) . '">
                                        <img class="" src="' . UrlHelper::generateUrl('image', 'shopLogo', array($moresellers['shop_id'], $siteLangId, 'SMALL')) . '" alt="' . $moresellers['shop_name'] . '">
                                    </a>
                                </figure>
                                <div class="shop-profile-data">
                                   
                                        <a class="title" title="' . $moresellers[$key] . '" href="' . UrlHelper::generateUrl('shops', 'view', array($moresellers['shop_id'])) . '">
                                            ' . $moresellers[$key] . '
                                        </a>
                                   
                                   
                                        <a class="location" href="' . UrlHelper::generateUrl('shops', 'view', array($moresellers['shop_id'])) . '">
                                            ' . $moresellers['shop_state_name'] . "," . $moresellers['shop_country_name'] . '
                                        </a>
                                    ';
                                        if (isset($product['rating'][$moresellers['selprod_user_id']]) && $product['rating'][$moresellers['selprod_user_id']] > 0) {
                                            $txt .= '<div class="rating">
                                                    <i class="icn">
                                                        <svg class="svg" width="16" height="16">
                                                            <use xlink:href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#star-yellow" href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#star-yellow">
                                                            </use>
                                                        </svg>
                                                    </i>
                                                    <span class="rate">
                                                        ' . round($product['rating'][$moresellers['selprod_user_id']], 1) . '
                                                    </span>
                                                </div>';
                                        }
                                        $txt .= $locationAction . '</div></div>';
                                        $td->appendElement('plaintext', array(), $txt, true);
                                        break;

                                    case 'selprod_price':
                                        if ($moresellers['is_sell']) {
                                            $txt = ' <div class=""><div >' . CommonHelper::displayMoneyFormat($moresellers['selprod_price']) . '</div></div>';
                                        } else {
                                            $txt = Labels::getLabel('LBL_N/A', $siteLangId);
                                        }
                                        $td->appendElement('plaintext', array(), $txt, true);
                                        break;
                                    case 'rent_price':
                                        if ($moresellers['is_rent'] && !empty($moresellers['sprodata_rental_active']) ) {
											$txt = '';
											if(applicationConstants::isProdMulRentalPricesActivated() == false) {
												$txt = CommonHelper::displayMoneyFormat($moresellers['rent_price']);
												/*if ($moresellers['sprodata_rental_price'] != $moresellers['rent_price']) {
													$txt .= '  <span class="item__price_old"><strike>' . CommonHelper::displayMoneyFormat($moresellers['sprodata_rental_price']) . '</strike></span>';
												}*/
											} else {
												$flag = 0;
												if (in_array(applicationConstants::RENT_TYPE_HOUR, $activeRentalDurations) && $moresellers['sprodata_hour_rental_price'] > 0) {
													if($moresellers['splprice_hour_price'] > 0) {
														$txt = CommonHelper::displayMoneyFormat($moresellers['splprice_hour_price']);
													} else {
														$txt = CommonHelper::displayMoneyFormat($moresellers['sprodata_hour_rental_price']);
													}
													$txt .= '/'.$rentalTypeArr[applicationConstants::RENT_TYPE_HOUR];
													$flag = 1;		
												}
												
												if (in_array(applicationConstants::RENT_TYPE_DAY, $activeRentalDurations) && $moresellers['sprodata_day_rental_price'] > 0) {
													if($flag == 1) {
														$txt .= '<br>';
													}
													$flag = 1;
													if($moresellers['splprice_day_price'] > 0) {
														$txt .= CommonHelper::displayMoneyFormat($moresellers['splprice_day_price']);
													} else {
														$txt .= CommonHelper::displayMoneyFormat($moresellers['sprodata_day_rental_price']);
													}
													$txt .= '/'.$rentalTypeArr[applicationConstants::RENT_TYPE_DAY]; 
												}
												
												if (in_array(applicationConstants::RENT_TYPE_WEEK, $activeRentalDurations) && $moresellers['sprodata_week_rental_price'] > 0) {
													if($flag == 1) {
														$txt .= '<br>';
													}
													$flag = 1;
													if($moresellers['splprice_week_price'] > 0) {
														$txt .= CommonHelper::displayMoneyFormat($moresellers['splprice_week_price']);
													} else {
														$txt .= CommonHelper::displayMoneyFormat($moresellers['sprodata_week_rental_price']);
													}
													$txt .= '/'.$rentalTypeArr[applicationConstants::RENT_TYPE_WEEK]; 
												}
												
												if (in_array(applicationConstants::RENT_TYPE_MONTH, $activeRentalDurations) && $moresellers['sprodata_month_rental_price'] > 0) {
													if($flag == 1) {
														$txt .= '<br>';
													}
													$flag = 1;
													if($moresellers['splprice_month_price'] > 0) {
														$txt .= CommonHelper::displayMoneyFormat($moresellers['splprice_month_price']);
													} else {
														$txt .= CommonHelper::displayMoneyFormat($moresellers['sprodata_month_rental_price']);
													}
													$txt .= '/'.$rentalTypeArr[applicationConstants::RENT_TYPE_MONTH]; 
												}
											}
                                        } else {
                                            $txt = Labels::getLabel('LBL_N/A', $siteLangId);
                                        }
                                        $td->appendElement('plaintext', array(), $txt, true);
                                        break;
                                    case 'COD':
                                        $codAvailableTxt = Labels::getLabel('LBL_N/A', $siteLangId);
                                        if (!empty($product['cod'][$moresellers['selprod_user_id']]) && $product['cod'][$moresellers['selprod_user_id']]) {
                                            $codAvailableTxt = Labels::getLabel('LBL_Cash_on_delivery_available', $siteLangId);
                                        }
                                        $td->appendElement('plaintext', array(), $codAvailableTxt, true);
                                        break;
                                    case 'Action':
                                        $txt = '<ul class="actions">';
                                        $txt .= '<li class="actions-item">';
                                        $txt .= '<a class="actions-link" title="' . Labels::getLabel('LBL_View', $siteLangId) . '"  href="' . UrlHelper::generateUrl('products', 'view', array($moresellers['selprod_id'])) . '" >  <svg class="svg" width="16" height="16">
                                        <use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/retina/sprite.svg#view">
                                        </use>
                                    </svg></a>';
                                        $txt .= '</li>';

                                        if ($moresellers['sprodata_rental_active'] == applicationConstants::ACTIVE) {
                                            $txt .= '<li class="actions-item">';
                                            $txt .= '<button type="button" class="actions-link" onclick="quickDetail(' . $moresellers['selprod_id'] . ')" title="' . Labels::getLabel('LBL_Rent_Now', $siteLangId) . '" ><svg class="svg" width="16" height="16">
                                            <use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/retina/sprite.svg#rent-now">
                                            </use>
                                        </svg></button>';
                                            $txt .= '</li>';
                                        }
                                        if (ALLOW_SALE && strtotime($moresellers['selprod_available_from']) <= strtotime(date('Y-m-d h:i:s')) && $moresellers['selprod_active'] == applicationConstants::ACTIVE && $moresellers['selprod_stock'] > 0) {
                                            $txt .= '<li class="actions-item">';
                                            $txt .= '<button class="actions-link btnAddToCart--js" title="' . Labels::getLabel('LBL_Add_to_cart', $siteLangId) . '" data-id="' . $moresellers['selprod_id'] . '" data-min-qty="' . $moresellers['selprod_min_order_qty'] . '" > <svg class="svg" width="16" height="16">
                                            <use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/retina/sprite.svg#add-cart">
                                            </use>
                                        </svg></button>';
                                            $txt .= '</li>';
                                        }


                                        $txt .= '</ul>';
                                        $td->appendElement('plaintext', array(), $txt, true);
                                        break;
                                    default:
                                        $td->appendElement('plaintext', array(), $moresellers[$key], true);
                                        break;
                                }
                            }
                        }
                        echo $tbl->getHtml();
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>