<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="addonModalLabel">
                <?php echo Labels::getLabel('LBL_Shipping_Charges', $siteLangId); ?>
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

            </button>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="my-addresses">
                        <?php
                        if (!empty($addresses)) {
                            foreach ($addresses as $address) { ?>
                                <li class="my-addresses-item">
                                    <div class="my-addresses-body">
                                        <label class="radio">
                                            <input type="radio" name="addressOption" value="default" id="type_default--js"
                                                checked>
                                        </label>
                                        <address class="delivery-address">
                                            <h5><?php echo $address['addr_name']; ?><span
                                                    class="tag"><?php echo $address['addr_title']; ?></span></h5>
                                            <p>
                                                <?php echo $address['addr_address1'] ?>
                                                <?php echo (strlen($address['addr_address2']) > 0) ? $address['addr_address2'] . '<br>' : ''; ?>
                                                <?php echo (strlen($address['addr_city']) > 0) ? $address['addr_city'] . ',' : ''; ?>
                                                <?php echo (strlen($address['state_name']) > 0) ? $address['state_name'] : ''; ?>
                                                <?php echo (strlen($address['country_name']) > 0) ? $address['country_name'] : ''; ?>
                                                <?php echo (strlen($address['addr_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $siteLangId) . ' ' . $address['addr_zip'] . '<br>' : ''; ?>
                                            </p>
                                            <p class="phone-txt">
                                                <svg class="svg" width="16" height="16">
                                                    <use
                                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                                    </use>
                                                </svg>
                                                <?php echo (strlen($address['addr_phone']) > 0) ? Labels::getLabel('LBL_Phone:', $siteLangId) . ' ' . $address['addr_dial_code'] . ' ' . $address['addr_phone'] . '<br>' : ''; ?>
                                            </p>
                                        </address>
                                        <input type="hidden" id="default-address_id" value="<?php echo $address['addr_id']; ?>">
                                    </div>
                                </li>
                            <?php } ?>
                            <div class="or my-1">
                                <span>OR</span>
                            </div>
                        <?php } ?>
                        <li class="my-addresses-item">
                            <div class="my-addresses-body">
                                <label class="radio">
                                    <input type="radio" name="addressOption" value="distance" id="type_distance--js"
                                        <?php echo empty($addresses) ? 'checked="checked"' : ''; ?>>
                                </label>

                                <div class="locations-autocomplete">
                                    <input class="locations-autocomplete-input location_autocomplete location-selected"
                                        id="distance-ga" type="text"
                                        placeholder="<?php echo Labels::getLabel('LBL_Add_Delivery_Location', $siteLangId); ?>">
                                    <button class="locations-autocomplete-detect" type="button"
                                        onclick="geocodeLocation(this); return false;">
                                        <svg class="svg" width="16" height="16">
                                            <use
                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#location-detect">
                                            </use>
                                        </svg>
                                    </button>
                                </div>

                                <input type="hidden" id="distance-lat" name="lat">
                                <input type="hidden" id="distance-lng" name="lng">
                                <input type="hidden" id="distance-country_code" name="country_code">
                                <input type="hidden" id="distance-state_code" name="state_code">
                            </div>
                        </li>
                    </ul>

                </div>
            </div>
            <div class="row justify-content-end mt-3">
                <div class="col-md-4">
                    <div class="form-group">
                        <div class="field-wraper">
                            <div class="field_cover">
                                <input type="hidden" name="selprodId" value="<?php echo $selprodId; ?>" />
                                <input type="hidden" name="productType" value="<?php echo $productType; ?>" />
                                <input class="btn btn-brand btn-block" type="submit" name="btn_submit"
                                    value="<?php echo Labels::getLabel('LBL_Get_rates', $siteLangId); ?>"
                                    onclick="getRates(); return (false);">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row shipping-locations-cont">
                <div class="col-sm-12">
                    <div id="search-result--js"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    getCountryStates($('select[name="country_id"]').val(), '', $('select[name="state_id"]'));
    $(document).on('change', 'select[name="country_id"]', function () {
        getCountryStates($('select[name="country_id"]').val(), '', $('select[name="state_id"]'));
    });

    function handleEvent(event) {
        document.getElementById('type_distance--js').click();
    }


    function initAutocomplete() {
        var el = document.getElementById('distance-ga');
        var options = {
            types: []
        };
        el.addEventListener('focus', function () {
            document.getElementById('type_distance--js').click();
        });
        
        var autocomplete = new google.maps.places.Autocomplete(el, options);
        google.maps.event.addListener(autocomplete, "place_changed", function () {
            var place = autocomplete.getPlace();
            document.getElementById("distance-country_code").value = '';
            document.getElementById("distance-state_code").value = '';
            document.getElementById("distance-lat").value = place["geometry"]["location"].lat();
            document.getElementById("distance-lng").value = place["geometry"]["location"].lng();
            if (0 < place.address_components.length) {
                var addressComponents = place.address_components;
                for (var i = 0; i < addressComponents.length; i++) {
                    var key = place.address_components[i].types[0];
                    var value = place.address_components[i].long_name;
                    if ("country" == key) {
                        document.getElementById("distance-country_code").value = place.address_components[i]
                            .short_name;
                    } else if ("administrative_area_level_1" == key) {
                        document.getElementById("distance-state_code").value = place.address_components[i]
                            .short_name;
                    }
                }
            }
        });
    }

    function getRates() {
        let addressType = $('input[name="addressOption"]:checked').val();
        if (addressType == 'distance') {
            let customAddress = ($('#distance-ga').val()).trim();
            if (!customAddress) {
                $.systemMessage(langLbl.enterLocation, "alert--danger");
                return "";
            }
        }
        let selprodId = $('input[name="selprodId"]').val();
        let productType = $('input[name="productType"]').val();
        let data = 'selprodId=' + selprodId + '&productType=' + productType + '&addressType=' + addressType;
        if ($('input[name="addressOption"]:checked').val() == 'distance') {
            let lat = $('#distance-lat').val();
            let lng = $('#distance-lng').val();
            let countryCode = $('input[name="country_code"]').val();
            let stateCode = $('input[name="state_code"]').val();
            data += '&countryCode=' + countryCode + '&stateCode=' + stateCode + '&lat=' + lat + '&lng=' + lng;
        } else {
            let addressId = $('#default-address_id').val();
            data += '&addressId=' + addressId;
        }
        fcom.ajax(fcom.makeUrl('Products', 'getShippingLocations'), data, function (t) {
            if (isJson(t)) {
                let res = JSON.parse(t);
                $("#search-result--js").html('');
                $.systemMessage(res.msg, 'alert--danger');
            } else {
                $("#search-result--js").html(t);
                $(".shipping-locations-cont").show();
            }
        })

    }

    $(document).ready(function () {
        initAutocomplete();
    });
</script>
<style>
    .pac-container {
        z-index: 1061;
    }
</style>