<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('class', 'form form-search');
$frm->setFormTagAttribute('onsubmit', 'setupRequestForQuote(this); return(false);');

$keyFld = $frm->getField('rfq_request_type');
$keyFld->setFieldTagAttribute('onChange', 'toggleRequestType(this.value);');

$keyFld = $frm->getField('rfq_fulfilment_type');
$keyFld->setFieldTagAttribute('onChange', 'toggleFulfilmentStatues(this.value);');

$btnFld = $frm->getField('btn_submit');
$btnFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block'); 

$rentalStartDateFld = $frm->getField('rfq_from_date');
$rentalStartDateFld->addFieldTagAttribute('class', 'rental_datescalendar--js--start field--calender');

$rentalStartDateFld = $frm->getField('rfq_to_date');
$rentalStartDateFld->addFieldTagAttribute('class', 'rental_datescalendar--js--end field--calender');

?>

<div class="modal-dialog modal-lg modal-dialog-centered" role="document" id="sign-in">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title">
                <?php echo Labels::getLabel('LBL_Request_For_Quote_For:', $siteLangId); ?>&nbsp;<span
                    class="primary-color"><?php echo $productData['selprod_title']; ?></span>
            </h5>

            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

            </button>
        </div>
        <div class="modal-body">
            <?php echo $frm->getFormTag(); ?>
            <div class="row">

                <div class="col-lg-6  ">
                    <div class="form-group">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('rfq_quantity');
                                echo $fld->getCaption();
                                ?>
                                <span class="spn_must_field">*</span>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('rfq_quantity'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if (ALLOW_SALE) { ?>
                <div class="col-lg-6  ">
                    <div class="form-group">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                    $fld = $frm->getField('rfq_request_type');
                                    echo $fld->getCaption();
                                    ?>
                                <span class="spn_must_field">*</span>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('rfq_request_type'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } else {
                    echo $frm->getFieldHtml('rfq_request_type');
                } ?>
                <div class="col-lg-6">
                    <div class="form-group">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('rfq_fulfilment_type');
                                echo $fld->getCaption();
                                ?>
                                <span class="spn_must_field">*</span>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('rfq_fulfilment_type'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="form-group">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('rfq_from_date');
                                echo $fld->getCaption();
                                ?>
                            </label>
                            <span class="spn_must_field rfq-date-range-asterisk">*</span>
                        </div>
                        <div class="field-wraper date-selector field--calender-daterange--js">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('rfq_from_date'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="form-group">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('rfq_to_date');
                                echo $fld->getCaption();
                                ?>
                            </label>
                            <span class="spn_must_field rfq-date-range-asterisk">*</span>
                        </div>
                        <div class="field-wraper date-selector field--calender-daterange--js">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('rfq_to_date'); ?>
                            </div>
                        </div>
                    </div>
                </div>


                <?php
                $commentFldClass = 'col-lg-12';
                if ($productData['selprod_type'] == SellerProduct::PRODUCT_TYPE_ADDON && $productData['selprod_document_required'] == applicationConstants::YES) {
                    $commentFldClass = 'col-lg-6  ';
                }
                ?>
                <div class="<?php echo $commentFldClass; ?>">
                    <div class="form-group">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('rfq_comments');
                                echo $fld->getCaption();
                                ?>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('rfq_comments'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                if ($productData['selprod_type'] == SellerProduct::PRODUCT_TYPE_ADDON && $productData['selprod_document_required'] == applicationConstants::YES) {
                    ?>
                <div class="col-lg-6  " id="document-fld-js">
                    <div class="form-group">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php echo Labels::getLabel('LBL_Upload_documents', $siteLangId); ?>
                                <span class="spn_must_field">*</span>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <input type="file" name="rfq_documents" onchange="uploadDocument()" />
                            </div>
                            <div id="uploaded-documents-js" class="uploaded--documents"></div>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>

            <?php if (!empty($services)) { ?>
            <div class="row">
                <div class="col-lg-12">
                    <table class="table table-services">
                        <tbody>
                            <?php foreach ($services as $serviceId => $val) { ?>
                            <tr class="<?php echo ($val['selprod_document_required']) ? "no-border-row" : ""; ?>">
                                <td>
                                    <h6><span class="primary-color"><?php echo $val['selprod_title']; ?></span></h6>
                                </td>
                                <td>
                                    <div class="form-group">
                                        <div class="caption-wraper">
                                            <label class="form-label">
                                                <?php
                                                        $fld = $frm->getField('rfq_required_capacity_service[' . $serviceId . ']');
                                                        echo $fld->getCaption();
                                                        ?>
                                            </label>
                                        </div>
                                        <div class="field-wraper">
                                            <div class="field_cover">
                                                <?php echo $frm->getFieldHtml('rfq_required_capacity_service[' . $serviceId . ']'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="form-group">
                                        <div class="caption-wraper">
                                            <label class="form-label">
                                                <?php
                                                        $fld = $frm->getField('rfq_quantity_service[' . $serviceId . ']');
                                                        echo $fld->getCaption();
                                                        ?>
                                            </label>
                                        </div>
                                        <div class="field-wraper">
                                            <div class="field_cover">
                                                <?php echo $frm->getFieldHtml('rfq_quantity_service[' . $serviceId . ']'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php } ?>


            <div class="row">
                <div class="col-lg-12">
                    <div class="form-group">
                        <div class="caption-wraper">
                            <h6 id="billing" style="display: none;">
                                <?php echo Labels::getLabel("LBL_Billing_Address", $siteLangId); ?>
                            </h6>
                            <h6 id="shipping">
                                <?php echo Labels::getLabel("LBL_Shipping_&_Billling_Address", $siteLangId); ?>
                            </h6>
                        </div>
                    </div>
                </div>
                <?php if ($addresses) { ?>
                <div class="col-lg-12" id="shipping-address">
                    <ul class="my-addresses">
                        <?php foreach ($addresses as $address) { ?>
                        <li
                            class="my-addresses-item <?php echo ($address['addr_is_default'] == applicationConstants::YES) ? 'is--selected' : ''; ?>">
                            <label id="address_<?php echo $address['addr_id']; ?>"
                                class="my-addresses-body address-billing  ">
                                <div class="address-inner">
                                    <span class="radio">
                                        <input
                                            <?php echo ($address['addr_is_default'] == applicationConstants::YES) ? 'checked="checked"' : ''; ?>
                                            name="rfq_ship_address_id" value="<?php echo $address['addr_id']; ?>"
                                            type="radio">
                                    </span>
                                    <address class="delivery-address">
                                        <h5><span><?php echo ($address['addr_title'] != '') ? $address['addr_name'] . '</span>' . '<span class="tag">' . $address['addr_title'] . ' </span> ' : $address['addr_name']; ?>
                                        </h5>
                                        <?php echo (strlen($address['addr_address1']) > 0) ? $address['addr_address1'] . ', ' : ''; ?>
                                        <?php echo (strlen($address['addr_address2']) > 0) ? $address['addr_address2'] . ', ' : ''; ?>
                                        <?php echo (strlen($address['addr_city']) > 0) ? $address['addr_city'] . ', ' : ''; ?>
                                        <?php echo (strlen($address['state_name']) > 0) ? $address['state_name'] . ', ' : ''; ?>
                                        <?php echo (strlen($address['country_name']) > 0) ? $address['country_name'] . ', ' : ''; ?>
                                        <?php echo (strlen($address['addr_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $siteLangId) . ' ' . $address['addr_zip'] . ' ' : ''; ?>
                                        <p class="phone-txt">
                                            <?php echo (strlen($address['addr_phone']) > 0) ? '<svg class="svg" width="16" height="16"><use xlink:href="'.CONF_WEBROOT_URL.'images/retina/sprite.svg#mobile"></use></svg> ' . $address['addr_dial_code'] . ' ' . $address['addr_phone'] . '' : ''; ?>
                                        </p>
                                    </address>
                                </div>
                            </label>
                        </li>
                        <?php } ?>
                </div>
                <?php } else { ?>
                <div class="col-lg-12">
                    <p class="mb-3">
                        <?php // echo sprintf(Labels::getLabel("LBL_To_submit_rfq_you_need_to_add_delivery_address_%s_click_here_to_add_new_address_%s", $siteLangId), ' <br> <a class="link-underline" href="' . CommonHelper::generateUrl('account', 'MyAddresses') . '" target="_blank">', '</a> '); ?>
                        <?php echo Labels::getLabel("LBL_To_submit_rfq_you_need_to_add_delivery_address", $siteLangId) . '<br/><a class="link-underline" href="' . CommonHelper::generateUrl('account', 'MyAddresses') . '" target="_blank">'.Labels::getLabel("LBL_click_here_to_add_new_address", $siteLangId).'</a> '; ?>
                    </p>
                </div>
                <?php
                }
                ?>
            </div>

            <div class="row mt-5" id="pickup">
                <div class="col-lg-12">
                    <div class="form-group">
                        <div class="caption-wraper">
                            <h6><?php echo Labels::getLabel("LBL_Pickup_address", $siteLangId); ?></h6>
                        </div>
                    </div>
                </div>
                <?php if ($shopAddress) { ?>
                <div class="col-lg-12">
                    <ul class="my-addresses">
                        <?php foreach ($shopAddress as $address) { ?>
                        <li class="my-addresses-item">
                            <label id="address_<?php echo $address['addr_id']; ?>"
                                class="my-addresses-body address-billing">
                                <div class="address-inner">
                                    <span class="radio">
                                        <input
                                            <?php echo ($address['addr_is_default'] == applicationConstants::YES) ? 'checked="checked"' : ''; ?>
                                            name="rfq_pickup_address_id" value="<?php echo $address['addr_id']; ?>"
                                            type="radio">
                                    </span>
                                    <address class="delivery-address">
                                        <h5><span><?php echo ($address['addr_title'] != '') ? $address['addr_name'] . '</span>' . '<span class="tag">' . $address['addr_title'] . ' </span> ' : $address['addr_name']; ?>
                                        </h5>
                                        <?php echo (strlen($address['addr_address1']) > 0) ? $address['addr_address1'] . ', ' : ''; ?>
                                        <?php echo (strlen($address['addr_address2']) > 0) ? $address['addr_address2'] . ', ' : ''; ?>
                                        <?php echo (strlen($address['addr_city']) > 0) ? $address['addr_city'] . ', ' : ''; ?>
                                        <?php echo (strlen($address['state_name']) > 0) ? $address['state_name'] . ', ' : ''; ?>
                                        <?php echo (strlen($address['country_name']) > 0) ? $address['country_name'] . ', ' : ''; ?>
                                        <?php echo (strlen($address['addr_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $siteLangId) . ' ' . $address['addr_zip'] . '' : ''; ?>
                                        <p class="phone-txt">
                                            <?php echo (strlen($address['addr_phone']) > 0) ? '<svg class="svg" width="16" height="16"><use xlink:href="'.CONF_WEBROOT_URL.'images/retina/sprite.svg#mobile"></use></svg> ' . $address['addr_dial_code'] . ' ' . $address['addr_phone'] . '<br>' : ''; ?>
                                        </p>
                                    </address>
                                </div>
                            </label>
                        </li>
                        <?php } ?>
                    </ul>
                </div>
                <?php } else { ?>
                <div class="col-lg-12">
                    <div class="info my-3">
                        <svg class="svg" width="16" height="16">
                            <use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/retina/sprite.svg#info">
                            </use>
                        </svg>
                        <?php echo sprintf(Labels::getLabel("LBL_Pickup_Address_Not_Available", $siteLangId)); ?>


                    </div>
                </div>
                <?php
                }
                ?>
            </div>

            <div class="row justify-content-end mt-5">
                <div class="col-lg-4">
                    <div class="form-group">
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php
                                echo $frm->getFieldHtml('selprod_id');
                                echo $frm->getFieldHtml('shop_id');
                                echo $frm->getFieldHtml('group_id');
                                echo $frm->getFieldHtml('parent_id');
                                echo $frm->getFieldHtml('btn_submit');
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $frm->getExternalJs(); ?>
            </form>
        </div>
    </div>
</div>

<script>
$('input[name="rfq_pickup_address_id"]').on('change', function() {
    $('#pickup li').removeClass('active');
    $(this).parents('li').addClass('active');
});
$('input[name="rfq_ship_address_id"]').on('change', function() {
    $('#shipping-address li').removeClass('active');
    $(this).parents('li').addClass('active');
});
</script>


<script>
$(document).ready(function() {
    $("#pickup").hide();

    // var datepickerOption = {
    //     autoClose: true,
    //     minDate: new Date(),
    //     dateFormat: "yy/mm/dd",
    //     startDate: new Date(),
    //     showShortcuts: false,
    //     inline: true,
    //     container: ".field--calender-daterange--js",
    //     customArrowPrevSymbol: '<i class=""><svg width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M7.82843 10.9999H20V12.9999H7.82843L13.1924 18.3638L11.7782 19.778L4 11.9999L11.7782 4.22168L13.1924 5.63589L7.82843 10.9999Z"></path></svg></i>',

    //     customArrowNextSymbol: '<i class=""><svg width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M16.1716 10.9999L10.8076 5.63589L12.2218 4.22168L20 11.9999L12.2218 19.778L10.8076 18.3638L16.1716 12.9999H4V10.9999H16.1716Z"></path></svg></i>',
    //     stickyMonths: true,
    // };
    // $('.rfq_dates--js').dateRangePicker(datepickerOption).bind('datepicker-change', function(event, obj) {
    //     var selectedDates = obj.value;
    //     var datesArr = selectedDates.split(" to ");
    //     $('input[name="rfq_date_range"]').val(obj.value);
    //     $('input[name="rfq_from_date"]').val(datesArr[0]);
    //     $('input[name="rfq_to_date"]').val(datesArr[1]);
    // });
});
$(document).ready(function () {
        var openPicker = null; 
        'use strict';
        $('.rental_datescalendar--js--start').datetimepicker({
            step: <?php echo Product::PRODUCT_RENTAL_SLOTS_DURATION; ?>,
            formatDate: 'Y-m-d',
            formatTime: 'H:i',
            minTime:'00:00',
            closeOnDateSelect:false,
            defaultDate:'<?php echo  date('Y-m-d', strtotime('+1 day'));; ?>',
            minDate:'<?php echo  date('Y-m-d', strtotime('+1 day'));; ?>',
            format: 'Y-m-d H:i',
            onShow: function (ct) {
                if (openPicker && openPicker !== this) {
                    $(openPicker).datetimepicker('hide'); // Close previously open picker
                }
                openPicker = this; // Set current open picker
            },
            onClose: function () {
                openPicker = null; // Reset on close
            },
            onSelectDate: function (ct, $i) {
                $i.val(''); 
            },
            onSelectTime: function (ct, $i) {
                let dateObject = $($i).datetimepicker('getValue');
                if (dateObject) {
                    let year = dateObject.getFullYear();
                    let month = String(dateObject.getMonth() + 1).padStart(2, '0'); // Months are zero-indexed
                    let day = String(dateObject.getDate()).padStart(2, '0');
                    let hours = String(dateObject.getHours()).padStart(2, '0');
                    let minutes = String(dateObject.getMinutes()).padStart(2, '0');
                    let formattedDateTime = `${year}-${month}-${day} ${hours}:${minutes}`;
                    $i.val(formattedDateTime);
                }
            }
        });
        $('.rental_datescalendar--js--end').datetimepicker({
            step: <?php echo Product::PRODUCT_RENTAL_SLOTS_DURATION; ?>,
            formatDate: 'Y-m-d',
            formatTime: 'H:i',
            minTime:'01:00',
            closeOnDateSelect:false,
            defaultDate:'<?php echo  date('Y-m-d', strtotime('+1 day'));; ?>',
            minDate:'<?php echo  date('Y-m-d', strtotime('+1 day'));; ?>',
            format: 'Y-m-d H:i',
            onShow: function (ct) {
                if (openPicker && openPicker !== this) {
                    $(openPicker).datetimepicker('hide'); 
                }
                openPicker = this; 
            },
            onClose: function () {
                openPicker = null; 
            },
            onSelectDate: function (ct, $i) {
                $i.val(''); 
            },
            onSelectTime: function (ct, $i) {
                let dateObject = $($i).datetimepicker('getValue');
                if (dateObject) {
                    let year = dateObject.getFullYear();
                    let month = String(dateObject.getMonth() + 1).padStart(2, '0'); // Months are zero-indexed
                    let day = String(dateObject.getDate()).padStart(2, '0');
                    let hours = String(dateObject.getHours()).padStart(2, '0');
                    let minutes = String(dateObject.getMinutes()).padStart(2, '0');
                    let formattedDateTime = `${year}-${month}-${day} ${hours}:${minutes}`;
                    $i.val(formattedDateTime);
                }
            }
        });
            
    });

    $('#exampleModal').on('hidden.bs.modal', function () {
        $('.rental_datescalendar--js--end').datetimepicker('hide');
        $('.rental_datescalendar--js--start').datetimepicker('hide');
    });



var FULFILMENT_TYPE_PICK = <?php echo Shipping::FULFILMENT_PICKUP; ?>;
</script>
<style>
.disabled-input {
    pointer-events: none;
}

.disabled-input input {
    color: rgba(0, 0, 0, 0.38) !important;
    background-color: rgba(0, 0, 0, 0.12) !important;
    box-shadow: none;
    cursor: initial;
    border-color: transparent !important;
}
</style>