<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main" role="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading">
                    <?php echo $pageTitle; ?>
                </h2>
            </div>
        </div>
        <div class="content-form">
            <?php
            $frmSearch->setFormTagAttribute('id', 'frmSearchAddonProduct');
            $frmSearch->setFormTagAttribute('class', 'form form-search');
            $frmSearch->setFormTagAttribute('onsubmit', 'searchProductQuotes(this); return(false);');

            $frmSearch->changeFieldPosition(7, 3);

            $frmSearch->getField('keyword')->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search_by', $siteLangId));
            $frmSearch->developerTags['colClassPrefix'] = 'col-md-';
            $frmSearch->developerTags['fld_default_col'] = 12;

            $keywordFld = $frmSearch->getField('keyword');
            $keywordFld->setWrapperAttribute('class', 'col-lg-6');
            $keywordFld->developerTags['col'] = 6;

            $keyFld = $frmSearch->getField('request_from_date');
            $keyFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Date_From', $siteLangId));
            $keyFld->setWrapperAttribute('class', 'col-lg-2');
            $keyFld->developerTags['col'] = 2;

            $keyFld = $frmSearch->getField('request_to_date');
            $keyFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Date_To', $siteLangId));
            $keyFld->setWrapperAttribute('class', 'col-lg-2');
            $keyFld->developerTags['col'] = 2;

            $typeFld = $frmSearch->getField('rfq_status');
            $typeFld->setWrapperAttribute('class', 'col-lg-2');
            $typeFld->developerTags['col'] = 2;

            if (ALLOW_SALE && ALLOW_RENT) {
                $frmSearch->changeFieldPosition(8, 3);
                $typeFld = $frmSearch->getField('rfq_request_type');
                $typeFld->setWrapperAttribute('class', 'col-lg-2');
                $typeFld->developerTags['col'] = 2;
            }
            $submitFld = $frmSearch->getField('btn_submit');
            $submitFld->setFieldTagAttribute('class', 'btn-block btn btn-brand');
            $submitFld->setWrapperAttribute('class', 'col-lg-2');
            $submitFld->developerTags['col'] = 2;

            $fldClear = $frmSearch->getField('btn_clear');
            $fldClear->setFieldTagAttribute('onclick', 'clearSearch()');
            $fldClear->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
            $fldClear->setWrapperAttribute('class', 'col-lg-2');
            $fldClear->developerTags['col'] = 2;

            echo $frmSearch->getFormHtml();
            ?>

        </div>
        <div class="content-body">
            <div class="card">
                <div class="card-table">
                    <div id="listing">

                        <?php echo Labels::getLabel('LBL_Loading..', $siteLangId); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</main>