<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$shop_city = $shop['shop_city'];
$shop_state = (isset($shop['shop_city']) && strlen($shop['shop_city']) > 0) ? ', ' . $shop['shop_state_name'] : $shop['shop_state_name'];
$shop_country = (isset($shop_state) && strlen($shop_state) > 0) ? ', ' . $shop['shop_country_name'] : $shop['shop_country_name'];
$shopLocation = $shop_city . $shop_state . $shop_country;
?>
<main id="body" class="body">
    <?php
    $variables = array(
        'shop' => $shop,
        'siteLangId' => $siteLangId,
        'template_id' => $template_id,
        'collectionData' => [],
        'action' => $action,
        'shopTotalReviews' => $shopTotalReviews,
        'shopRating' => $shopRating,
        'socialPlatforms' => $socialPlatforms
    );
    $this->includeTemplate('shops/shop-header.php', $variables, false);
    ?>
    <!-- <div class="bg-brand pt-3 pb-3">
        <div class="container">
            <div class="row align-items-center justify-content-between">
                <div class="col-md-8 col-sm-8">
                    <div class="section-head section-head-white mb-0">
                        <div class="section-heading">
                            <h2><?php echo $shop['shop_name']; ?></h2>
                            <p><?php echo $shopLocation; ?>
                                <?php echo Labels::getLabel('LBL_Opened_on', $siteLangId); ?>
                                <?php echo FatDate::format($shop['shop_created_on']); ?></p>
                        </div>
                    </div>

                </div>
                <div class="col-md-auto col-sm-auto"><a href="<?php echo UrlHelper::generateUrl('Shops', 'view', array($shop['shop_id'])); ?>" class="btn btn-outline-white btn-sm"><?php echo Labels::getLabel('Lbl_Back_to_Shop', $siteLangId); ?></a>
                </div>
            </div>
        </div>
    </div> -->
    <section class="section" data-collection="collection-name">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div id="itemRatings">
                        <div class="section-head">
                            <h4>
                                <?php echo Labels::getLabel('Lbl_Reviews_for', $siteLangId) . ' ' . $shop['shop_name']; ?>
                            </h4>
                            <!-- static -->
                            <div class="btn-group-js">
                                <button class="btn btn-group btn-outline-gray dropdown-toggle" data-bs-toggle="dropdown"
                                    data-bs-auto-close="outside" type="button" aria-expanded="true">
                                    <?php echo Labels::getLabel('Lbl_Most_Recent', $siteLangId); ?>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-anim dropdown-menu-end">
                                    <li class="dropdown-menu-item">
                                        <button type="button" class="dropdown-menu-link" type="button"
                                            data-sort='most_recent' onclick="getSortedReviews(this);return false;">
                                            <?php echo Labels::getLabel('Lbl_Most_Recent', $siteLangId); ?> </button>
                                    </li>
                                    <li class="dropdown-menu-item">
                                        <button type="button" class="dropdown-menu-link" type="button"
                                            data-sort='most_helpful' onclick="getSortedReviews(this);return false;">
                                            <?php echo Labels::getLabel('Lbl_Most_Helpful', $siteLangId); ?> </button>
                                    </li>
                                </ul>
                            </div>
                            <!-- /static -->
                        </div>
                        <?php echo $frmReviewSearch->getFormHtml(); ?>
                        <div class="section-body">
                            <?php $this->includeTemplate('_partial/shop-reviews.php', array('reviews' => $reviews, 'siteLangId' => $siteLangId, 'shop_id' => $shop['shop_id']), false); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>