<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/dashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading">
                    <?php if ($isActiveSale) { ?>
                    <a class="btn btn-back" title="<?php echo Labels::getLabel('LBL_Back_To_My_Inventory', $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('sellerInventories', 'sales'); ?>">
                        <svg class="svg" width="24" height="24">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                            </use>
                        </svg>
                    </a>
                    <?php } else { ?>
                    <a class="btn btn-back" title="<?php echo Labels::getLabel('LBL_Back_To_My_Inventory', $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('sellerInventories', 'products'); ?>">
                        <svg class="svg" width="24" height="24">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                            </use>
                        </svg>
                    </a>
                    <?php } ?>
                    <?php echo Labels::getLabel('LBL_Inventory_Setup', $siteLangId); ?>
                </h2>
            </div>
        </div>
        <div class="content-body">
            <div class="card card-tabs">
                <?php if (ALLOW_SALE) { ?>
                <div class="card-head">
                    <ul class="nav nav-tabs tabs-grcustom navTabsJs tabs_nav-js">
                        <?php if (!FatApp::getConfig('CONF_ALLOW_MEMBERSHIP_MODULE', FatUtility::VAR_INT, 0)) { ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($selprod_id > 0) ? 'tabs_001' : ''; ?>" rel="tabs_001" href="javascript:void(0)">
                                <?php echo Labels::getLabel('LBL_Rent', $siteLangId); ?>
                            </a>
                        </li>
                        <?php } else { ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($selprod_id > 0) ? 'tabs_002' : ''; ?>"" rel="tabs_002" href="javascript:void(0)">
                                <?php echo Labels::getLabel('LBL_Membership', $siteLangId); ?>
                            </a>
                        </li>
                        <?php } ?>
                        <?php /* } */ ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($selprod_id > 0 || $isActiveSale == 1) ? 'tabs_003' : ''; ?>" rel="tabs_003" href="javascript:void(0)">
                                <?php echo Labels::getLabel('LBL_Sale', $siteLangId); ?>
                            </a>
                        </li>
                    </ul>
                </div>
                <?php } ?>
                <div class="card-body">
                    <div class="tabs-content">
                        <div id="tabs_001" class="tabs_panel" style="display: <?php echo ($isActiveSale == 0) ? "block;" : "none;"; ?>"></div>
                        <div id="tabs_002" class="tabs_panel" style="display: none;"></div>
                        <?php if (ALLOW_SALE) { ?>
                        <div id="tabs_003" class="tabs_panel" style="display: <?php echo ($isActiveSale == 0) ? "none;" : "block;"; ?>"></div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<script>
var product_id = <?php echo $product_id; ?>;
var selprod_id = <?php echo $selprod_id; ?>;
var ALLOW_SALE = <?php echo ALLOW_SALE; ?>;
$(document).ready(function() {
    <?php if ($isActiveSale == 0) { ?>
    <?php if (!FatApp::getConfig('CONF_ALLOW_MEMBERSHIP_MODULE', FatUtility::VAR_INT, 0)) { ?>
    sellerProductForm(product_id, selprod_id);
    <?php } else { ?>
    productMembershipForm(product_id, selprod_id);
    <?php } ?>
    <?php } else { ?>
    productSaleDetails(product_id, selprod_id);
    <?php } ?>
});
</script>