<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$brandReqLangFrm->setFormTagAttribute('class', 'form form--horizontal layout--' . $formLayout);
$brandReqLangFrm->developerTags['colClassPrefix'] = 'col-lg-12 col-md-12 col-sm-';
$brandReqLangFrm->developerTags['fld_default_col'] = 12;
$brandReqLangFrm->setFormTagAttribute('onsubmit', 'setupBrandReqLang(this); return(false);');
$brandFld = $brandReqLangFrm->getField('brand_name');
$brandFld->setFieldTagAttribute('onblur', 'checkUniqueBrandName(this,$("select[name=lang_id]").val(),' . $brandReqId . ')');

$langFld = $brandReqLangFrm->getField('lang_id');
$langFld->setfieldTagAttribute('onChange', "addBrandReqLangForm(" . $brandReqId . ", this.value);");

$submitFld = $brandReqLangFrm->getField('btn_submit');
$submitFld->setFieldTagAttribute('class', 'btn btn-brand');
$submitFld->developerTags['noCaptionTag'] = true;
?>

<div class="modal-dialog modal-dialog-centered" role="document" id="brand-req-lang-form">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title"><?php echo (FatApp::getConfig('CONF_BRAND_REQUEST_APPROVAL', FatUtility::VAR_INT, 0)) ? Labels::getLabel('LBL_Request_New_Brand', $siteLangId) : Labels::getLabel('LBL_New_Brand', $siteLangId) ?></h5>

            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

            </button>
        </div>
        <div class="modal-body">
            <div class="box-body">
                <ul class="nav nav-tabs tabs-grcustom navTabsJs">
                    <li class="nav-item "><button type="button" class="nav-link" onclick="addBrandReqForm(<?php echo $brandReqId ?>);"><?php echo Labels::getLabel('LBL_Basic', $siteLangId); ?></button></li>
                    <?php $inactive = ($brandReqId == 0) ? ' fat-inactive' : ''; ?>
                    <li class="nav-item <?php echo (0 < $brandReqLangId) ? 'is-active' : '';
                                        echo $inactive; ?>">
                        <button class="nav-link">
                            <?php echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
                        </button>
                    </li>
                    <li class="nav-item <?php echo $inactive; ?>">
                        <button type="button" class="nav-link" <?php if ($brandReqId > 0) { ?> onclick="brandMediaForm(<?php echo $brandReqId ?>);" <?php } ?>><?php echo Labels::getLabel('LBL_Media', $siteLangId); ?></button>
                    </li>
                </ul>
                <div class="tabs-content form">
                    <?php
                    $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
                    $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
                    if (!empty($translatorSubscriptionKey) && $brandReqLangId != $siteDefaultLangId) { ?>
                        <div class="row justify-content-end">
                            <div class="col-auto mt-3">
                                <button type="button" class="btn btn-outline-gray btn-icon btn-language" title="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $siteLangId); ?>" onClick="addBrandReqLangForm(<?php echo $brandReqId; ?>, <?php echo $brandReqLangId; ?>, 1)">
                                    <svg class="svg" width="24" height="24">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#translate"></use>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    <?php } ?>
                    <?php
                    echo $brandReqLangFrm->getFormHtml();
                    ?>
                </div>
            </div>
        </div>

    </div>
</div>