<div class="modal-dialog modal-dialog-lg modal-dialog-centered" role="document" id="custom-catalog-info-modal">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title"><?php echo Labels::getLabel('LBL_Custom_catalog_info', $siteLangId); ?></h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> </button>
        </div>
        <div class="modal-body">
            <div class="white--bg">
                <div class="row">
                    <div class="col-lg-6">
                        <div id="img-static" class="product-detail-gallery">
                            <img
                                src="<?php echo CommonHelper::generateUrl('image', 'customProduct', array($product['preq_id'], 'MEDIUM', 0, 0, $siteLangId)) ?>">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="product-description">
                            <div class="product-description-inner">
                                <h5 class="">
                                    <?php echo $product['product_name'] ?? Labels::getLabel('LBL_N/A', $siteLangId); ?>
                                </h5>
                                <div class="gap"></div>
                                <div class="cms">
                                    <table class="table">
                                        <tbody>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Category', $siteLangId); ?>:</th>
                                                <td><?php echo $product['prodcat_name'] ?? Labels::getLabel('LBL_N/A', $siteLangId); ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Brand', $siteLangId); ?>:</th>
                                                <td><?php echo $product['brand_name'] ?? Labels::getLabel('LBL_N/A', $siteLangId); ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Product_Model', $siteLangId); ?>:
                                                </th>
                                                <td><?php echo $product['product_model'] ?? Labels::getLabel('LBL_N/A', $siteLangId); ?>
                                                </td>
                                            </tr>
                                            <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) {
                                                if (isset($product['product_min_selling_price']) && $product['product_min_selling_price'] > 0) { ?>
                                                    <tr>
                                                        <th><?php echo Labels::getLabel('LBL_Minimum_Selling_Price', $siteLangId); ?>:
                                                        </th>
                                                        <td><?php echo CommonHelper::displayMoneyFormat($product['product_min_selling_price']); ?>
                                                        </td>
                                                    </tr>
                                                <?php }
                                            } ?>
                                            <?php
                                            $taxArr = Tax::getSaleTaxCatArr($siteLangId);
                                            if (isset($product['ptt_rent_taxcat_id']) && array_key_exists($product['ptt_rent_taxcat_id'], $taxArr)) { ?>
                                                <tr>
                                                    <th><?php echo Labels::getLabel('LBL_Tax_Category', $siteLangId); ?>:
                                                    </th>
                                                    <td><?php echo $taxArr[$product['ptt_rent_taxcat_id']] ?? Labels::getLabel('LBL_N/A', $siteLangId); ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>