<?php
$variables = array('siteLangId' => $siteLangId, 'action' => $action, 'recordCountArr' => $recordCountArr);
$this->includeTemplate('seller-requests/_partial/requests-navigation.php', $variables, false); ?>
<div class="card-body">
    <div class="scroll scroll-x js-scrollable table-wrap">
        <?php defined('SYSTEM_INIT') or die('Invalid Usage.');
        $arr_flds = array(
            'listserial' => Labels::getLabel('LBL_#', $siteLangId),
            'brand_name' => Labels::getLabel('LBL_Brand_Name', $siteLangId),
            'brand_requested_on' => Labels::getLabel('LBL_Requested_on', $siteLangId),
            'brand_status' => Labels::getLabel('LBL_Status', $siteLangId),
        );
        if ($canEdit) {
            $arr_flds['action'] = '';
        }
        $tableClass = '';
        if (0 < count($arr_listing)) {
            $tableClass = "table-justified";
        }
        $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table ' . $tableClass));
        $th = $tbl->appendElement('thead')->appendElement('tr', array('class' => ''));
        foreach ($arr_flds as $val) {
            $e = $th->appendElement('th', array(), $val);
        }

        $sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
        foreach ($arr_listing as $sn => $row) {
            $tr = $tbl->appendElement('tr', array('class' => ''));

            foreach ($arr_flds as $key => $val) {
                $td = $tr->appendElement('td');
                switch ($key) {
                    case 'listserial':
                        $td->appendElement('plaintext', array(), $sr_no, true);
                        break;
                    case 'brand_name':
                        $brandName = (!empty($row['brand_name'])) ? $row['brand_name'] : $row['brand_identifier'];
                        $html = '<div class="product-profile"><figure class="product-profile-thumbnail"><img src="' . UrlHelper::getCachedUrl(CommonHelper::generateUrl('image', 'brand', array($row['brand_id'], "SMALL", 0, 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg') . '?t=' . time() . '" title="' . $brandName . '" alt="' . $brandName . '"></figure>
				<div class="product-profile-data">
					<div class="product-profile-title">' . $brandName . '</div>
					<div class="product-profile-brand"> (' . $row['brand_identifier'] . ') </div>
				</div></div>';
                        $td->appendElement('plaintext', array(), $html, true);
                        break;
                    case 'brand_status':
                        if (isset($statusArr[0])) {
                            $statusArr[0] = Labels::getLabel('LBL_Draft', $siteLangId);
                        }
                        $td->appendElement('span', array('class' => 'badge badge-inline ' . $statusClassArr[$row[$key]]), $statusArr[$row[$key]] . '<br>', true);
                        $td->appendElement('p', array('class' => 'ml-1'), (isset($row['brand_status_updated_on']) && $row['brand_status_updated_on'] != '0000-00-00 00:00:00') ? FatDate::Format($row['brand_status_updated_on']) : '', true);
                        break;
                    case 'brand_requested_on':
                        $td->appendElement('plaintext', array(), (isset($row[$key]) && $row[$key] != '0000-00-00 00:00:00') ? FatDate::Format($row[$key]) : Labels::getLabel('LBL_NA', $siteLangId), true);
                        break;
                    case 'action':
                        $ul = $td->appendElement("ul", array('class' => 'actions'), '', true);
                        $li = $ul->appendElement("li", array("class" => "actions-item"));
                        if ($row['brand_status'] == Brand::BRAND_REQUEST_PENDING) {
                            $li->appendElement(
                                'button',
                                array('type' => 'button', 'onclick' => "addBrandReqForm(" . $row['brand_id'] . ")", 'class' => 'actions-link', 'title' => Labels::getLabel('LBL_Edit', $siteLangId)),
                                '<i class="fa fa-edit"></i>',
                                true
                            );
                        }
                        break;
                    default:
                        $td->appendElement('plaintext', array(), $row[$key], true);
                        break;
                }
            }
            $sr_no--;
        }

        echo $tbl->getHtml();
        if (count($arr_listing) == 0) {
            $message = Labels::getLabel('LBL_No_Records_Found', $siteLangId);
            $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'message' => $message));
        } ?>
    </div>
    <?php $postedData['page'] = $page;
    echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmSearchBrandRequestPag'));
    $pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'callBackJsFunc' => 'goToBrandSearchPage', 'siteLangId' => $siteLangId, 'pageSize' => $pageSize, 'removePageCentClass' => true, 'recordCount' => $recordCount);
    $this->includeTemplate('_partial/pagination.php', $pagingArr, false);
    ?>
</div>