<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$frmSearchCustomProduct->setFormTagAttribute('onsubmit', 'searchCustomProducts(this); return(false);');
$frmSearchCustomProduct->setFormTagAttribute('class', 'form form-search');
$frmSearchCustomProduct->developerTags['colClassPrefix'] = 'col-md-';
$frmSearchCustomProduct->developerTags['fld_default_col'] = 12;

$keyFld = $frmSearchCustomProduct->getField('keyword');
$keyFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Keyword', $siteLangId));
$keyFld->setWrapperAttribute('class', 'col-sm-6');
$keyFld->developerTags['col'] = 8;

$submitBtnFld = $frmSearchCustomProduct->getField('btn_submit');
$submitBtnFld->value = Labels::getLabel('LBL_Search', $siteLangId);
$submitBtnFld->setFieldTagAttribute('class', 'btn-block');
$submitBtnFld->setWrapperAttribute('class', 'col-sm-3');
$submitBtnFld->developerTags['col'] = 2;

$cancelBtnFld = $frmSearchCustomProduct->getField('btn_clear');
$cancelBtnFld->value = Labels::getLabel("LBL_Clear", $siteLangId);
$cancelBtnFld->setFieldTagAttribute('class', 'btn-block');
$cancelBtnFld->setWrapperAttribute('class', 'col-sm-3');
$cancelBtnFld->developerTags['col'] = 2;
?>
<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading"><?php echo Labels::getLabel('LBL_My_Product', $siteLangId); ?></h2>
            </div>
        </div>
        <div class="content-body">
            <div class="card">
                <div class="card-head">
                    <h5 class="card-title"><?php echo Labels::getLabel('LBL_My_Products_list', $siteLangId); ?></h5>
                    <div class="action">
                        <div class="">
                            <button type="button" onclick="addCatalogPopup()" class="btn btn-brand btn-sm  btn-add"><?php echo Labels::getLabel('LBL_Add_New_Product', $siteLangId); ?></button>
                            <a href="<?php echo UrlHelper::generateUrl('seller', 'catalog'); ?>" class="btn btn-outline-gray qwer">
                                <svg class="svg" width="16" height="16">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#add">
                                    </use>
                                </svg><?php echo Labels::getLabel('LBL_Products_List', $siteLangId); ?></a>

                        </div>
                    </div>
                </div>
                <div class="card-head">
                    <?php echo $frmSearchCustomProduct->getFormHtml(); ?>
                </div>

                <div class="card-body"> <?php echo $frmSearchCustomProduct->getExternalJS(); ?>
                    <div id="listing">
                        <?php echo Labels::getLabel('LBL_Loading..', $siteLangId); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>