var advanceMedia = false; /* open via advance media*/
var autoOpenSideBar = true;
$(document).ready(function(){

    fixWidthHelper = function (e, ui) {
        ui.children().each(function () {
            $(this).width($(this).width());
        });
        return ui;
    }

    fixPlaceholderStyle = function (e, ui) {
        ui.placeholder.height(ui.item.height());
        ui.placeholder.css("visibility", "visible");
        ui.placeholder.css('background-color', '#f3f6f9');
    }

    /* Fix width of table headings. */
    fixTableColumnWidth = function () {
        if (0 < $('.listingTableJs').length) {
            $('.listingTableJs').each(function () {
                let autoColumnWidth = $(this).attr('data-autoColumnWidth');
                if ('undefined' == typeof autoColumnWidth || 0 < autoColumnWidth || '' == autoColumnWidth) {
                    fixWidth($(this));
                }
            });
        } else {
            let autoTableColumWidth = $('.listingTableJs').data('autoColumnWidth');
            if (1 > autoTableColumWidth) {
                return false;
            }
            fixWidth($('.listingTableJs'));
        }
    }

    fixWidth = function (formObj) {
        var thWidthArr = [];

        $('.tableHeadJs th', formObj).each(function () {
            var arr = {
                'width': $(this).outerWidth(true),
                'element': $(this)
            };
            thWidthArr.push(arr);
        });
        /* Sort By width */
        thWidthArr.sort((a, b) => (a.width > b.width) ? 1 : -1)
        /* Sort By width */

        $.each(thWidthArr, function (index, value) {
            var width = value.width;
            var element = value.element;
            $(element).attr('width', width);
        });
    }
    getLangId = function() {
        return $("#addProductfrm [name='lang_id']").val();
    };

    getProductId = function() {
        return $("#addProductfrm [name='product_id']").val();
    };

    getTempProductId = function() {
        return $("#addProductfrm [name='temp_record_id']").val();
    };

    getSelectedCats = () => {
        return $('#ptc_prodcat_id').val();
    }

    /* Product Brand Request [ */

    addBrandReqForm = function (id) {
        fcom.ajax(fcom.makeUrl('sellerRequests', 'addBrandReqForm', [id]), '', function (t) {
            $('#exampleModal').html(t);
            $('#exampleModal').modal('show');
        });
    };

    setupBrandReq = function (frm) {
        if (!$(frm).validate()) return;
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(
          fcom.makeUrl("sellerRequests", "setupBrandReq"),
          data,
          function (t) {
            $.mbsmessage.close();
    
            if (t.langId > 0) {
              addBrandReqLangForm(t.brandReqId, t.langId);
              return;
            }
            $("#exampleModal").modal('hide');
          }
        );
    };
    
    addBrandReqLangForm = function (brandReqId, langId, autoFillLangData = 0) {
        fcom.ajax(
            fcom.makeUrl("sellerRequests", "brandReqLangForm", [brandReqId,langId,autoFillLangData,]), "", function (t) {
                $("#exampleModal").html(t);
                $("#exampleModal").modal("show");
            }
        );
    };
    
    setupBrandReqLang = function (frm) {
        if (!$(frm).validate()) return;
        var data = fcom.frmData(frm);
        fcom.updateWithAjax( fcom.makeUrl("sellerRequests", "brandReqLangSetup"), data, function (t) {
            if (t.langId > 0) {
                addBrandReqLangForm(t.brandReqId, t.langId);
                return;
            }
            if (t.openMediaForm) {
                brandMediaForm(t.brandReqId);
                return;
            }
            $("#exampleModal").modal('hide');
        });
    };

    checkUniqueBrandName = function (obj, $langId, $brandId) {
        data = "brandName=" + $(obj).val() + "&langId= " + $langId + "&brandId= " + $brandId;
        fcom.ajax(fcom.makeUrl("Brands", "checkUniqueBrandName"), data, function (t) {
            $.mbsmessage.close();
            $res = $.parseJSON(t);
            if ($res.status == 0) { 
                $(obj).val("");
                $alertType = "alert--danger";
                $.mbsmessage($res.msg, true, $alertType);
            }
        });
    };
    
    brandMediaForm = function (brandId) {
        fcom.ajax( fcom.makeUrl("sellerRequests", "brandMediaForm", [brandId]), "", function (t) {
            $("#exampleModal").html(t);
            $("#exampleModal").modal("show");
        });
    };
    
    removeBrandLogo = function (brandId, langId) {
        if (!confirm(langLbl.confirmDelete)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl("sellerRequests", "removeBrandLogo", [brandId, langId]), "", function (t) {
            brandMediaForm(brandId);
            reloadList();
        });
    };
	
	brandPopupImage = function (inputBtn) {
        
        if (inputBtn.files && inputBtn.files[0]) {
            
            fcom.ajax(fcom.makeUrl('Seller', 'imgCropper'), '', function (t) {
                
                var file = inputBtn.files[0];
                if(!file){
                    return false;
                }
                let fileType = file.type.split('/')[0]; 
                if (fileType != 'image') {
                    $(inputBtn).val('');
                    $.mbsmessage("Please choose an image file.", true, 'alert--danger');
                    return false;
                }
                $('#cropperBox-js').html(t);
                $("#cropperBox-js .modal-header").hide();
                $("#brandMediaForm-js").css("display", "none");
                var ratioType = document.frmBrandMedia.ratio_type.value;
                var aspectRatio = 1 / 1;
                if (ratioType == ratioTypeRectangular) {
                    aspectRatio = 16 / 5
                }
                var options = {
                    aspectRatio: aspectRatio,
                    preview: '.img-preview',
                    imageSmoothingQuality: 'high',
                    imageSmoothingEnabled: true,
                    crop: function (e) {
                        var data = e.detail;
                    }
                };
                $(inputBtn).val('');
                return cropImage(file, options, 'uploadBrandLogo', inputBtn);
            });
        }
    };

    uploadBrandLogo = function (formData) {
        var brandId = document.frmBrandMedia.brand_id.value;
        var langId = document.frmBrandMedia.brand_lang_id.value;
        var ratio_type = $('input[name="ratio_type"]:checked').val();
        formData.append('brand_id', brandId);
        formData.append('lang_id', langId);
        formData.append('ratio_type', ratio_type);
        $.ajax({
            url: fcom.makeUrl('SellerRequests', 'uploadBrandLogo'),
            type: 'post',
            dataType: 'json',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function () {
                $('#loader-js').html(fcom.getLoader());
            },
            complete: function () {
                $('#loader-js').html(fcom.getLoader());
            },
            success: function (ans) {
                $('.text-danger').remove();
                $('#input-field').html(ans.msg);
                if (ans.status == true) {
                    $('#input-field').removeClass('text-danger');
                    $('#input-field').addClass('text-success');
                    brandMediaForm(ans.brandId);
                } else {
                    $('#input-field').removeClass('text-success');
                    $('#input-field').addClass('text-danger');
                }
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    };
	
    /* ] */

    /* Product Category  request [ */
    addCategoryReqForm = function (id) {
        fcom.ajax(fcom.makeUrl('sellerRequests', 'categoryReqForm', [id]), '', function (t) {
           $('#exampleModal').html(t);
           $('#exampleModal').modal('show');
        });
    };
    setupCategoryReq = function (frm) {
        if (!$(frm).validate()) return;
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(fcom.makeUrl("sellerRequests", "setupCategoryReq"), data, function (t) {
            $("#exampleModal").modal('hide');
        });
    };
    /* ] */

    setup = function (frm) {
        if (!$(frm).validate()) {
            $('html,body').stop().animate({
                scrollTop: $('.error:first').offset().top,
            });
            return;
        }
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'setupCustomProduct'), data, function (res) {
            window.history.replaceState({},'', fcom.makeUrl('Seller', 'customProductForm', [res.productId]));
            setTimeout(function () {
                langForm(res.langId, 0, res.productId);
            }, 500);
        });
    };

    langForm = function(langId = 0, autoFillLangData = 0, recordId = 0) {
        recordId = recordId || getProductId();
        langId = langId || $("#addProductfrm [name='lang_id']").val();
        $('.mainJs').prepend(fcom.getLoader());
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'customProductForm', [recordId]), { langId, autoFillLangData }, function(res) {
            $('.mainJs').replaceWith(res.html);
        });
    };

    productDefaultImages = function() {
        let productId = getProductId();
        fileType = 0;
        if (1 > productId) {
            productId = getTempProductId();
            fileType = tempImageType;
        }
        
        fcom.ajax(fcom.makeUrl('Seller', 'scfImages', [productId, fileType, 0, 0]), { isDefaultLayout: 1 }, function(t) {
			console.log('--284--');
            $('#productDefaultImagesJs li').not(":first").remove();
            $('#productDefaultImagesJs').append(t.html);
        }, { fOutMode: 'json' });
    };

    productImages = function(product_id, file_type, option_id = 0, lang_id = 0) {
        option_id = option_id || 0;
        lang_id = lang_id || 0;
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'scfImages', [product_id, file_type, option_id, lang_id]), '', function(t) {
			console.log('--293--');
            $('#productImagesJs').html(t.html);
        });
    };

    imageForm = function() {
        let productId = getProductId();
        let tempProductId = getTempProductId();
        if (1 > productId) {
            if (tempProductId == undefined) {
                console.warn('temp product id is manatory');
                return;
            }
        }
		
		var prodOptions = new Array();
		$('input[name="prod_options[]"]').each(function(index, opval) {
			prodOptions.push(opval.value);
		});
		
		var data = 'prodOptions='+JSON.stringify(prodOptions);
        
        fcom.updateWithAjax(fcom.makeUrl('Seller', "scfImageForm", [productId, tempProductId]), data, function(t) {
			$('#exampleModal').html(t.html);
			$('#exampleModal').modal('show');
            loadImageOptions();
            var fileType = $('#image_file_type').val();
            var productId = $('#image_product_id').val();
            productImages(productId, fileType);
        });
    };

    loadImageOptions = function() {
        $('#addProductfrm .optionsJs').each(function() {
            let data = $(this).select2('data');
            if (data.length) {
                data = data[0];
                if (data.option_is_separate_images == 1) {
                    let optionValueData = $.parseJSON($(this).closest('.rowJs').find('input.optionValuesJs').val());
                    let optionIdEl = $('#image_option_id');
                    optionIdEl.html(`<option value="0">
                    ${forAllOptionsLbl}
                    </option>`);

                    $.each(optionValueData, function(index, opval) {
                        optionIdEl.append(`<option value="${opval.id}">
                            ${opval.value}
                            </option>`);

                    });
                    return false;
                }
            }

        })
    };

    validateFileUpload = function (file) {
        if (file.size >= langLbl.allowedFileSize) {
            let msg = langLbl.fileSizeExceeded;
            msg = msg.replace("{size-limit}", bytesToSize(langLbl.allowedFileSize));
            fcom.displayErrorMessage(msg);
            return false;
        }
        return true;
    }

    loadImageCropper = function(inputBtn) {
        loadCropper(inputBtn, true);
    }

    loadCropper = function (inputBtn, isAdvanceMedia = false) {
        advanceMedia = isAdvanceMedia || false;
        autoOpenSideBar = true;
        
        if (inputBtn.files && inputBtn.files[0]) {
            if (!validateFileUpload(inputBtn.files[0])) {
                return;
            }

			var frmName = $(inputBtn).closest('form').attr('name');
			var minWidth = document[frmName].min_width.value;
            var minHeight = document[frmName].min_height.value;	
			var file = inputBtn.files[0];
			
            fcom.ajax(fcom.makeUrl('Seller', 'imgCropper'), '', function (t) {
                if ($("#exampleModal").is(":visible")) {
                    $("#exampleModal").modal('hide');
                } 
				
                $('#exampleModal2').html(t);
                $('#exampleModal2').modal('show');
                /*$.yrmodal.close();*/
                var options = {
                    aspectRatio: minWidth / minHeight,
                    data: {
                        width: minWidth,
                        height: minHeight,
                    },
                    minCropBoxWidth: minWidth,
                    minCropBoxHeight: minHeight,
                    toggleDragModeOnDblclick: false,
                    imageSmoothingQuality: 'high',
                    imageSmoothingEnabled: true,
                };
                $(inputBtn).val('');
                return cropImage(file, options, 'mediaUpload', inputBtn);
            });
        }
    };
    
    mediaUpload = function(formData) {
        var frmName = formData.get("frmName");
        var frm = document.forms[frmName];
        var other_data = $('form[name="' + frmName + '"]').serializeArray();
        
        $.each(other_data, function(key, input) {
            formData.append(input.name, input.value);
        });

        action = 'scfSetupCustomProductImages';
        if (frmName == 'fileSpecFrm') {
            action = 'scfSetupCustomProductSpecFiles';
        }
            

        $.ajax({
            url: fcom.makeUrl('Seller', action),
            type: "post",
            dataType: "json",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#loader-js').html(fcom.getLoader());
            },
            success: function(ans) {
                if (ans.status == 0) {
                    $.mbsmessage(ans.msg, true, 'alert--danger');
                    return;
                }
                $("#exampleModal2").modal('hide');
                
                $.mbsmessage(ans.msg, true, 'alert--success');
                if (advanceMedia == true) {
                    /*$.yrmodal.show();*/
					$('#exampleModal').modal('show');
                    productImages(ans.productId, ans.file_type, ans.option_id, ans.lang_id);
                }

                $.mbsmessage(ans.msg, true, 'alert--success');
                if (ans.isDefaultLayout) {
                    productDefaultImages();
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                if (advanceMedia == true) {
                    /*$.yrmodal.show();*/
					$('#exampleModal').modal('show');
                }
                $.mbsmessage(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText, true, 'alert--danger');
            },
        });
    };
    
    deleteImage = function (product_id, image_id, file_type, isSizeChart = 0, isTempImg = 0, isDefaultLayout = 0) {
        var agree = confirm(langLbl.confirmDelete);
        if (!agree) {
            return false;
        }

        fcom.ajax(fcom.makeUrl('Seller', 'deleteCustomProductImage', [product_id, image_id, isSizeChart, isTempImg]), '', function (t) {
			var ans = $.parseJSON(t);
			if(isSizeChart != 1) {
				productDefaultImages();
				if (isDefaultLayout != 1) {
					productImages(product_id, file_type, t.optionId, t.langId);
				}
			}
			
			if (ans.status == 1) {
				$.mbsmessage(ans.msg, true, 'alert--success');
				if(isSizeChart == 1) {
					$('#size-chart-image-js').html('');
					$('#sizechart-temp-id-js').val(0);
				}
			} else {
				$.mbsmessage(ans.msg, true, 'alert--danger');
			}
        });
    };

    addSpecification = function() {
        let appendEle = $('#specificationsListJs');
        let identifier = $('#sp_identifier').val();
        let label = $('#sp_label').val();
        let value = $('#sp_value').val();
        let group = $('#sp_group').val();
        let prodSpecId = parseInt($('#sp_id').val());
        if (prodSpecId == NaN) {
            prodSpecId = 0;
        }
        if (!validateSpeficationForm()) {
            return;
        }

        $('#specificationsListSeprJs').removeClass('hidden');

        let rowCount = appendEle.find('tbody tr.editRowJs').length ? appendEle.find("tbody tr").index($(".editRowJs")) : appendEle.find('tbody tr').length;

        let html = '<tr data-id="' + prodSpecId + '">';
        html += '<td class="nameJs text-break">' + label + '<input type="hidden" name="specifications[' + rowCount + '][name]" value="' + label + '"  data-fatreq="{&quot;required&quot;:false}"/> <input class="identifierJs" type="hidden" name="specifications[' + rowCount + '][identifier]" value="' + identifier + '"  data-fatreq="{&quot;required&quot;:false}"/></td>';
        html += '<td class="valueJs text-break">' + value + '<input type="hidden" name="specifications[' + rowCount + '][value]" value="' + value + '" data-fatreq="{&quot;required&quot;:false}" /> </td>';
        html += '<td class="groupJs text-break">' + group + '<input type="hidden" name="specifications[' + rowCount + '][group]"  value="' + group + '" data-fatreq="{&quot;required&quot;:false}" /> </td>';
        html += '<td class="align-right"><ul class="actions">' +
            '<li class="actions-item"><input type="hidden" name="specifications[' + rowCount + '][id]" value="' + prodSpecId + '"  data-fatreq="{&quot;required&quot;:false}"/>' +
            '<a class="actions-link" href="javascript:void(0)"  onclick="editProdSpec(this)">' +
            '<i class="fa fa-edit"></i>' +
            '</a></li>' +
            '<li class="actions-item">' +
            '<a class="actions-link" href="javascript:void(0)" onclick="deleteProdSpec(this)">' +
            '<i class="fa fa-trash"></i>' +
            '</a></li>' +
            '</td>';
        html += '</ul></tr>';
        if (appendEle.find('.editRowJs').length) {
            appendEle.find('.editRowJs').replaceWith(html);
        } else {
            appendEle.find('tbody').append(html);
        }

        if (appendEle.find('table').hasClass('hidden')) {
            appendEle.find('table').removeClass('hidden');
            fixTableColumnWidth();
        }

        $('#sp_identifier').val('');
        $('#sp_label').val('');
        $('#sp_value').val('');
        $('#sp_group').val('');
        $('#sp_id').val(0);
        $('#btnAddSpecJs').text($('#btnAddSpecJs').data('addlbl'));

    };

    validateSpeficationForm = function() {
        let validate = true;
        $('#specificationsFormJs input').each(function() {
            if ($(this).data('change-event-bind') != 1) {
                $("input").change(function() {
                    $(this).siblings('ul').remove();
                });
                $(this).data('change-event-bind', 1);
            }
            $(this).siblings('ul').remove();
            if ($(this).data('required') == 1 && '' == $(this).val()) {
                let caption = $(this).siblings('label').text().trim();
                errorlist = $(document.createElement("ul")).addClass('errorlist').append(
                    $(document.createElement('li')).append($(document.createElement('a')).html(caption + " " + langLbl.isMandatory, ).attr({ 'href': 'javascript:void(0);' }))
                );
                $(this).after(errorlist);
                validate = false;
            }
        });
        return validate;
    };

    prodSpecifications = function() {
        var productId = getProductId();
        var langId = $("#addProductfrm [name='lang_id']").val();
        fcom.ajax(fcom.makeUrl('Seller', 'prodSpecificationsByLangId'), { product_id: productId, langId }, function(res) {
            $('#specificationsListJs').html(res.html);
            if ($('#specificationsListJs').find('table tbody tr').length == 0) {
                $('#specificationsListJs').find('table').addClass('hidden');
                $('#specificationsListSeprJs').addClass('hidden');
            }
        }, { fOutMode: 'json' });
    };

    editProdSpec = function(el) {
        let trEle = $(el).closest('tr');
        let prodSpecId = parseInt(trEle.data('id'));
        if (prodSpecId == NaN) {
            prodSpecId = 0;
        }

        let identifier = trEle.find('.identifierJs').val();
        let label = trEle.find('.nameJs').text();
        let value = trEle.find('.valueJs').text();
        let group = trEle.find('.groupJs').text();
        trEle.siblings().removeClass('editRowJs');
        trEle.addClass('editRowJs');

        $('#sp_identifier').val(identifier);
        $('#sp_label').val(label);
        $('#sp_value').val(value);
        $('#sp_group').val(group);
        $('#sp_id').val(prodSpecId);
        $('#btnAddSpecJs').text($('#btnAddSpecJs').data('updatelbl'));
        $('html,body').stop().animate({
            scrollTop: $('#specifications').offset().top,
        });
    };

    clearProdSpecForm = function () {
        $('#sp_label, #sp_identifier, #sp_value, #sp_group').val('');
        $('#sp_id').val(0);
        $('#btnAddSpecJs').text($('#btnAddSpecJs').data('addlbl'));
        $('#specificationsListJs tr.editRowJs').removeClass('editRowJs');
    };

    deleteProdSpec = function(el) {
		var agree = confirm(langLbl.confirmRemoveRecord);
        if (!agree) {
            return false;
        }
		
        let prodSpecId = $(el).closest('tr').data('id');
        let prodSpecLangId = $(el).data('langId');
        let productId = getProductId();
        if (1 > prodSpecId) {
            $(el).closest('tr').remove();
            if ($('#specificationsListJs').find('table tbody tr').length == 0) {
                $('#specificationsListJs').find('table').addClass('hidden');
                $('#specificationsListSeprJs').addClass('hidden');
            }
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'deleteProdSpec', [productId]), { prodSpecId, langId: prodSpecLangId }, function(t) {
            prodSpecifications();
        });
    };

    /** Specification Media [*/
    uploadFileSpecFile = (inputBtn) => {

        if (inputBtn.files && inputBtn.files[0]) {
            /* if (!validateFileSpeficationForm(inputBtn.files[0])) {
                return;
            } */
            var frmName = $(inputBtn).attr('data-frm')
            
            var formData = new FormData();
            formData.append("frmName", frmName);
            var file = inputBtn.files[0];
            var fileName = file["name"];
            var ext = fileName.split(".").pop().toLowerCase();
            var imageTypes = ["gif", "jpg", "jpeg", "png", "svg", "bmp", "tiff"];
            let langId = getLangId();
            $('#prodspec_is_file').val(1);
            if ($.inArray(ext, imageTypes) != -1) {
                fcom.ajax(fcom.makeUrl("Seller", "imgCropper"), "", function (t) {
                    $("#exampleModal").html(t);
                    $("#exampleModal").modal("show");
                    var minWidth = 800;
                    var minHeight = 800;
                    var options = {
                        aspectRatio: 1,
                        minCropBoxWidth: minWidth,
                        minCropBoxHeight: minHeight,
                        toggleDragModeOnDblclick: false,
                    };
                    $(inputBtn).val("");
                    return cropImage(
                        file,
                        options,
                        "uploadSpecificationFile",
                        inputBtn,
                        langId
                        );
                });
            } else {
                formData.append('file', file);
                $(inputBtn).val("");
                uploadSpecificationFile(formData);
            }
        }
    }

    uploadSpecificationFile = function (formData) {

        var frmName = formData.get("frmName");
        var frm = document.forms[frmName];
        var other_data = $('form[name="' + frmName + '"]').serializeArray();
        
        $.each(other_data, function(key, input) {
            formData.append(input.name, input.value);
        });

        $.ajax({
            url: fcom.makeUrl('Seller', 'scfSetupCustomProductSpecFiles'),
            type: "post",
            dataType: "json",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#loader-js').html(fcom.getLoader());
            },
            success: function(ans) {
                if (ans.status == 0) {
                    $.mbsmessage(ans.msg, true, 'alert--danger');
                    return;
                }
                $("#exampleModal").modal('hide');
                
                $.mbsmessage(ans.msg, true, 'alert--success');
                if (frmName == 'fileSpecFrm') {
                    /** TODOFS
                     * 1) add image/file icon below the input file tag
                     * 2)  On press Add button:
                     *  - Remove image/file icon below the input file tag
                     *  - Display all the information in the list table
                     *  - On press of product save button these entries will get saved in the main files table and
                     *  - specification text will get saved in the specifaication info table
                    */

                    $('#hiddenSpecFileIdJs').val(ans.spec_temp_id);
                    $('#hiddenSpecFileIdJs').attr('data-is_file', ans.prodspec_is_file);
                    $('#filespectempJs').html(ans.file_htm_tag);
                    
                } else {
                    if (advanceMedia == true) {
                        /*$.yrmodal.show();*/
						$('#exampleModal').modal('show');
                        productImages(ans.productId, ans.file_type, ans.option_id, ans.lang_id);
                    }

                    $.mbsmessage(ans.msg, true, 'alert--success');
                    if (ans.isDefaultLayout) {
                        productDefaultImages();
                    }
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                if (advanceMedia == true) {
                    /*$.yrmodal.show();*/
					$('#exampleModal').modal('show');
                }
                $.mbsmessage(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText, true, 'alert--danger');
            },
        });
    }

    addFileSpecification = function() {
        let appendEle = $('#file-specificationsListJs');
        let identifier = $('#fsp_identifier').val();
        let name = $('#fsp_name').val();
        let fileSpecId = parseInt($('#fsp_id').val());
        if (isNaN(fileSpecId)) {
            fileSpecId = 0;
        }

        let fileSpecFileId = parseInt($('#hiddenSpecFileIdJs').val());
        if (isNaN(fileSpecFileId)) {
            /*alert('Invalid file attached with ' + name);*/
			fileSpecFileId = 0;
        }

        $('#hiddenSpecFileIdJs').val(0);
        if (!validateFileSpeficationForm()) {
			if(fileSpecId < 1 && fileSpecFileId < 1 && appendEle.find('tbody tr.editRowJs').length < 1) {
				var errorHtml = '<ul class="errorlist erlist_specification_media"><li><a href="javascript:void(0);">'+langLbl.specificationFile+'</a></li></ul>';
				$('.erlist_specification_media').remove();
				$('#hiddenSpecFileFrmFileJs').after(errorHtml);
				return false;
			}
            return;
        }
		
		if(fileSpecId < 1 && fileSpecFileId < 1 && appendEle.find('tbody tr.editRowJs').length < 1) {
			var errorHtml = '<ul class="errorlist erlist_specification_media"><li><a href="javascript:void(0);">'+langLbl.specificationFile+'</a></li></ul>';
			$('.erlist_specification_media').remove();
			$('#hiddenSpecFileFrmFileJs').after(errorHtml);
            return false;
		}
		
        $('#file-specificationsListSeprJs').removeClass('hidden');

        let rowCount = appendEle.find('tbody tr.editRowJs').length ? appendEle.find("tbody tr").index($(".editRowJs")) : appendEle.find('tbody tr').length;
		
        let fileEl = $('#filespectempJs').html();
        
        $('#filespectempJs').text('');
        let html = '<tr data-id="' + fileSpecId + '" data-nfid="' + fileSpecFileId + '" data-ofid="' + fileSpecId + '">';
        html += '<td class="text-break">' + identifier + '</td>';
        html += '<td class="nameJs text-break">' + name + '<input type="hidden" name="filespecifications[' + rowCount + '][name]" value="' + name + '"  data-fatreq="{&quot;required&quot;:false}"/><input class="identifierJs" type="hidden" name="filespecifications[' + rowCount + '][identifier]" value="' + identifier + '"  data-fatreq="{&quot;required&quot;:false}"/></td><td class="fileJs text-break">' + fileEl + '</td>';
        html += '<td class="align-right"><ul class="actions">' +
            '<li class="actions-item"><input type="hidden" name="filespecifications[' + rowCount + '][id]" value="' + fileSpecId + '"  data-fatreq="{&quot;required&quot;:false}"/>' +
            '<input type="hidden" name="filespecifications[' + rowCount + '][temp_file_id]" value="' + fileSpecFileId + '"  data-fatreq="{&quot;required&quot;:false}"/>' +
            '<input type="hidden" name="filespecifications[' + rowCount + '][file_id]" value="' + fileSpecFileId + '"  data-fatreq="{&quot;required&quot;:false}"/>' +
            /* '<input type="hidden" name="filespecifications[' + rowCount + '][is_file]" value="' + isFile + '"  data-fatreq="{&quot;required&quot;:false}"/>' + */
            '<a class="actions-link" href="javascript:void(0)"  onclick="editFileSpec(this)">' +
            '<i class="fa fa-edit"></i>' +
            '</a></li>' +
            '<li class="actions-item">' +
            '<a class="actions-link" href="javascript:void(0)" onclick="deleteFileSpec(this)">' +
            '<i class="fa fa-trash"></i>' +
            '</a></li>' +
            '</td>';
        html += '</ul></tr>';

        if (appendEle.find('.editRowJs').length) {
            appendEle.find('.editRowJs').replaceWith(html);
        } else {
            appendEle.find('tbody').append(html);
        }

        if (appendEle.find('table').hasClass('hidden')) {
            appendEle.find('table').removeClass('hidden');
            fixTableColumnWidth();
        }

        $('#fsp_name').val('');
        $('#fsp_identifier').val('');
        $('#fsp_id').val(0);
        $('#btnAddFileSpecJs').text($('#btnAddFileSpecJs').data('addlbl'));
    };

    validateFileSpeficationForm = function() {
        let validate = true;
        $('#file-specificationsFormJs input').each(function() {
            if ($(this).data('change-event-bind') != 1) {
                $("input").change(function() {
                    $(this).siblings('ul').remove();
                });
                $(this).data('change-event-bind', 1);
            }
            $(this).siblings('ul').remove();
            if ($(this).data('required') == 1 && '' == $(this).val()) {
                let caption = $(this).siblings('label').text().trim();
                errorlist = $(document.createElement("ul")).addClass('errorlist').append(
                    $(document.createElement('li')).append($(document.createElement('a')).html(caption + " " + langLbl.isMandatory, ).attr({ 'href': 'javascript:void(0);' }))
                );
                $(this).after(errorlist);
                validate = false;
            }
        });
        return validate;
    };

    fileSpecifications = function() {
        var productId = getProductId();
        var langId = $("#addProductfrm [name='lang_id']").val();
        fcom.ajax(fcom.makeUrl('Seller', 'prodSpecificationsMediaByLangId'), { product_id: productId, langId }, function(res) {
            $('#file-specificationsListJs').html(res.html);
            if ($('#file-specificationsListJs').find('table tbody tr').length == 0) {
                $('#file-specificationsListJs').find('table').addClass('hidden');
                $('#file-specificationsListSeprJs').addClass('hidden');
            }
        }, { fOutMode: 'json' });
    };

    editFileSpec = function(el) {
        let trEle = $(el).closest('tr');
        let fileSpecId = parseInt(trEle.data('id'));
        if (fileSpecId == NaN) {
            fileSpecId = 0;
        }

        let name = trEle.find('.nameJs').text();
        let identifier = trEle.find('.identifierJs').val();
        let fileHtml = trEle.find('.fileJs').html();
        
        trEle.siblings().removeClass('editRowJs');
        trEle.addClass('editRowJs');

        $('#fsp_name').val(name);
        $('#fsp_identifier').val(identifier);
        $('#fsp_id').val(fileSpecId);
        $('#filespectempJs').html(fileHtml);
        
        $('#btnAddFileSpecJs').text($('#btnAddFileSpecJs').data('updatelbl'));
        $('html,body').stop().animate({
            scrollTop: $('#file-specifications').offset().top,
        });
    };

    clearFileSpecForm = function () {
        $('#fsp_name, #fsp_identifier').val('');
        $('#fsp_id').val(0);
        $('#filespectempJs').html('');
        $('#btnAddFileSpecJs').text($('#btnAddFileSpecJs').data('addlbl'));
        $('#file-specificationsListJs tr.editRowJs').removeClass('editRowJs');
    };

    deleteFileSpec = function(el) {
		var agree = confirm(langLbl.confirmRemoveRecord);
        if (!agree) {
            return false;
        }
        let prodSpecId = $(el).closest('tr').data('id');
        let fileSpecLangId = $(el).data('langId');
        let productId = getProductId();
        if (1 > prodSpecId) {
            $(el).closest('tr').remove();
            if ($('#file-specificationsListJs').find('table tbody tr').length == 0) {
                $('#file-specificationsListJs').find('table').addClass('hidden');
                $('#file-specificationsListSeprJs').addClass('hidden');
            }
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'deleteProdSpec', [productId]), { prodSpecId: prodSpecId, langId:fileSpecLangId }, function(t) {
            fileSpecifications();
        });
    };
    /** Specification Media ends here]*/
    brandAutocomplete = function (ths) {
        if ($(ths).val() == '') {
            $("input[name='product_brand_id']").val(0);
        }
        $('input[name=\'brand_name\']').autocomplete({
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function (request, response) {
                $.ajax({
                    url: fcom.makeUrl('brands', 'autoComplete'),
                    data: {
                        keyword: request['term'],
                        fIsAjax: 1
                    },
                    dataType: 'json',
                    type: 'post',
                    success: function (json) {
                        response($.map(json, function (item) {
                            return {
                                label: item['name'],
                                value: item['name'],
                                id: item['id']
                            };
                        }));
                    },
                });
            },
            'select': function (event, ui) {
                $('input[name=\'product_brand_id\']').val(ui.item.id);
            }
        });
    }
    
    categoryAutocomplete = function (ths) {
        if ($(ths).val() == '') {
            $("input[name='ptc_prodcat_id']").val(0);
        }
        $('input[name=\'category_name\']').autocomplete({
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function (request, response) {
                $.ajax({
                    url: fcom.makeUrl('products', 'linksAutocomplete'),
                    data: {
                        keyword: request['term'],
                        fIsAjax: 1
                    },
                    dataType: 'json',
                    type: 'post',
                    success: function (json) {
                        response($.map(json, function (item) {
                            return {
                                label: item['name'],
                                value: item['name'],
                                id: item['id']
                            };
                        }));
                    },
                });
            },
            'select': function (event, ui) {
                $('input[name=\'ptc_prodcat_id\']').val(ui.item.id);
                getCustomFields();
            }
        });
    }

    getCustomFields = (catId) => {

        if (!catId || isNaN(Number(catId)) || Number(catId) < 1) {
            catId = $('select[name="ptc_prodcat_id"] option:selected').val();
        }

        if (catId < 1) {
			disableCustomField();
            return;
        }

        let productId = getProductId();
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'scfProdCatCustomFieldsForm', []), { product_id: productId, cat_id: catId, lang_id: getLangId() }, function(res) {
            if (res.status == 1 && res.have_custom_fields == 1) {
                $('#customfields').removeClass('disabled');
                $('#customfields').show();
                $('#customfields-block').collapse('show');
                $('#CustomFieldsFormJs').html(res.html);
                return;
            }
            disableCustomField();
        });
    }

    disableCustomField = () => {
        $('#customfields').addClass('disabled');
		$('#customfields').hide();
        $('#customfields-block').collapse('hide');
        $('#CustomFieldsFormJs').html('');
    }
    
    rentTaxCatNameRent = function (ths) {
        if ($(ths).val() == '') {
            $("input[name='ptt_taxcat_id_rent']").val(0);
        }
        $('input[name=\'taxcat_name_rent\']').autocomplete({
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function(request, response) {
                $.ajax({
                    url: fcom.makeUrl('products', 'autoCompleteTaxCategories'),
                    data: {
                        keyword: request['term'],
                        fIsAjax: 1
                    },
                    dataType: 'json',
                    type: 'post',
                    success: function(json) {
                        response($.map(json, function(item) {
                            return {
                                label: item['name'],
                                value: item['name'],
                                id: item['id']
                            };
                        }));
                    },
                });
            },
            select: function(event, ui) {
                $('input[name=\'ptt_taxcat_id_rent\']').val(ui.item.id);
            }
        });
    }

    taxCatNameRent = function (ths) {
        if ($(ths).val() == '') {
            $("input[name='ptt_taxcat_id']").val(0);
        }  
        $('input[name=\'taxcat_name\']').autocomplete({
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function(request, response) {
                $.ajax({
                    url: fcom.makeUrl('products', 'autoCompleteTaxCategories'),
                    data: {
                        keyword: request['term'],
                        fIsAjax: 1
                    },
                    dataType: 'json',
                    type: 'post',
                    success: function(json) {
                        response($.map(json, function(item) {
                            return {
                                label: item['name'],
                                value: item['name'],
                                id: item['id']
                            };
                        }));
                    },
                });
            },
            select: function(event, ui) {
                $('input[name=\'ptt_taxcat_id\']').val(ui.item.id);
            }
        });
    }

    getTagsAutoComplete = function(e){
        var keyword = e.detail.value;
        tagify.loading(true).dropdown.hide.call(tagify)
        var list = [];
        fcom.ajax(fcom.makeUrl('Seller', 'tagsAutoComplete'), {keyword:keyword}, function(t) {          
            var ans = $.parseJSON(t);
            for (i = 0; i < ans.length; i++) {            
                list.push({
                    "id" : ans[i].id,
                    "value" : ans[i].tag_identifier, 
                });
            } 
            tagify.settings.whitelist = list;
            tagify.loading(false).dropdown.show.call(tagify, keyword);
        });       
    }

    tagifyProducts = function() {
        var element = '#product_tags';
        if ('undefined' !== typeof $(element).attr('disabled')) {
            return;
        }
        $(element).siblings(".tagify").remove();
        tagify = new Tagify(document.querySelector(element), {
            whitelist: [],
            delimiters: "#",
            editTags: false,
        }).on('add', addTagData).on('remove', removeTagData).on('input', getTagsAutoComplete).on('focus', getTagsAutoComplete);;
    };

    addTagData = function (e) {
        let rt_id = e.detail.data.id;
        if (rt_id == '' || rt_id == undefined) {
            if (1 > canEditTags) {
                fcom.displayErrorMessage(tagsEditErr);
                e.detail.tag.remove();
                return;
            }
        }
    };

    removeTagData = function(e) {
        var tag_id = e.detail.tag.id;
        var product_id = getProductId();
        if (1 > product_id || '' == tag_id) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'removeProductTag'), 'product_id=' + product_id + '&tag_id=' + tag_id, function(t) {});
        tagifyProducts();
    };
	
	tagifyOptions  = function() {
        var element = '#product-options-js';
        if ('undefined' !== typeof $(element).attr('disabled')) {
            return;
        }
        $(element).siblings(".tagify").remove();
        tagifyOptions = new Tagify(document.querySelector(element), {
            whitelist: [],
            delimiters: "#",
            editTags: false,
        }).on('add', addOption).on('remove', removeOption).on('input', getOptionsAutoComplete).on('focus', getOptionsAutoComplete);
    };
	
	addOption = function (e) {
		var option_id = e.detail.tag.id;
		if (option_id == '') {
			$(e.detail.tag).remove();
		} else {
			var recordId = getProductId();
			
			if(recordId > 0) {
				var selectedOptions = $('#product-options-js').val();
				alert(selectedOptions);
			} else {
				var selectedOptions = $('#product-options-js').val();
				if(selectedOptions != '') {
					validateAttachedOptions(selectedOptions, e);
				}
			}
			//alert(option_id);
			//$(e.detail.tag).remove();
			//updateProductOption(preq_id, option_id, e);
		}
	}
	
	/*validateAttachedOptions = function($optionsData, e) {
		fcom.ajax(fcom.makeUrl("Seller", "validateAttachedOptions"), "optionsData=" + $optionsData, function (t) {
			var ans = $.parseJSON(t);
			if (ans.status == 0) {
				console.log(e);
				console.log(e.detail.data.id);
				$(e.detail.tag).remove();
				var selectedOptions = $('#product-options-js').val();
				res = $.parseJSON(selectedOptions);
				console.log(res);
				var output = []
				$.each(res, function (key, value) {
					if(e.detail.data.id != value.id) {
					var obj = {}
					obj['id'] = value.id;
					obj['value'] = value.value;
					output.push(obj);
					}
	
					//if(e.detail.data.id == value.id) {
						//delete res[key];
					//}
					console.log(key+'--'+value.id+'---'+value.value);
				});
				//$('#product-options-js').val(JSON.stringify(output));
				alert(tagifyOptions.DOM.originalInput.value);
				alert($('#product-options-js').length);
				$('#product-options-js').val('abc');
				//console.log(output);
				//alert(selectedOptions);
				//alert(tagifyOptions.value);
				$.systemMessage(ans.msg, "alert--danger");
			}
		  }
		);
	}*/

	removeOption = function (e) {
		var option_id = e.detail.tag.id;
		alert(option_id);
		//removeProductOption(preq_id, option_id);
	}
	
	getOptionsAutoComplete = function(e) {
        var keyword = e.detail.value;
        tagifyOptions.loading(true).dropdown.hide.call(tagifyOptions)
        var listOptions = [];
        fcom.ajax(fcom.makeUrl('Seller', 'autoCompleteOptions'), {keyword:keyword}, function(t) {          
            var ans = $.parseJSON(t);
            for (i = 0; i < ans.length; i++) {            
                listOptions.push({
                    "id" : ans[i].id,
                    "value" : ans[i].name + '(' + ans[i].option_identifier + ')',
                });
            } 
            tagifyOptions.settings.whitelist = listOptions;
            tagifyOptions.loading(false).dropdown.show.call(tagifyOptions, keyword);
        });
    };
	
	/* [ UPLOAD SIZE CHART IMAGE */
	popupSizeChartImage = function (inputBtn) {
		if (inputBtn.files && inputBtn.files[0]) {
            /* if (!validateFileSpeficationForm(inputBtn.files[0])) {
                return;
            } */
            var frmName = $(inputBtn).attr('data-frm')
            
            var formData = new FormData();
            formData.append("frmName", frmName);
            var file = inputBtn.files[0];
            formData.append('file', file);
			uploadSizeChartImages(formData);
			$(inputBtn).val("");
        }
	};

	uploadSizeChartImages = function (formData) {
		var product_id = getProductId();
		/*var lang_id = document.imageFrm.lang_id.value;*/
		var lang_id = getLangId();
		formData.append('temp_record_id', getTempProductId());
        if($('input[name="auto_update_other_langs_data_prod_size_chart"]').length > 0){
            let isChecked = $('input[name="auto_update_other_langs_data_prod_size_chart"]').is(':checked');
            formData.append("auto_update_other_langs_data_prod_size_chart", isChecked);
        }
		formData.append("product_id", product_id);
		formData.append("lang_id", lang_id);
		$.ajax({
		url: fcom.makeUrl("Seller", "setupSizeChart"),
		type: "post",
		dataType: "json",
		data: formData,
		cache: false,
		contentType: false,
		processData: false,
		beforeSend: function () {
		  $("#loader-js").html(fcom.getLoader());
		},
		complete: function () {
		  $("#loader-js").html(fcom.getLoader());
		},
		success: function (ans) {
		  if (ans.status == 1) {
			  $('#size-chart-image-js').html(ans.retFileTag);
			  $('#sizechart-temp-id-js').val(ans.size_chart_temp_id);
			  $('#size-chart-card-js').show();
			  $.mbsmessage(ans.msg, true, 'alert--success');
		  } else {
			  $.mbsmessage(ans.msg, true, 'alert--danger');
		  }
		}
		});
    };
    /* ] */
});

$(document).on('change', '#image_option_id', function () {
    let optionId = $(this).val();
    let fileType = $('#image_file_type').val();
    let recordId = $('#image_product_id').val();
    let langId = $('#image_lang_id').val();
    productImages(recordId, fileType, optionId, langId);
});

$(document).on('change', '#image_lang_id', function () {
    let langId = $(this).val();
    let fileType = $('#image_file_type').val();
    let recordId = $('#image_product_id').val();
    let optionId = $('#image_option_id').val();
    productImages(recordId, fileType, optionId, langId);
});