<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$frmSearch->setFormTagAttribute('class', 'form form-search');
$frmSearch->setFormTagAttribute('onsubmit', 'searchSeoProducts(this); return(false);');
$frmSearch->developerTags['colClassPrefix'] = 'col-md-';

$keywordFld = $frmSearch->getField('keyword');
$keywordFld->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search_Product', $siteLangId));
$keywordFld->developerTags['noCaptionTag'] = true;

$submitFld = $frmSearch->getField('btn_submit');
$submitFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block');
$clearFld = $frmSearch->getField('btn_clear');
$clearFld->setFieldTagAttribute('onclick', 'clearSearch()');
$clearFld->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
?>
<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading"><?php echo Labels::getLabel('LBL_Meta_Tags', $siteLangId); ?></h2>
            </div>
        </div>
        <div class="content-form">
            <?php echo $frmSearch->getFormTag(); ?>
            <div class="row">
                <div class="col-lg-8">
                    <label class="form-label"><?php echo $frmSearch->getField('keyword')->getCaption(); ?></label>
                    <div class="field-set"><?php echo $frmSearch->getFieldHTML('keyword'); ?></div>
                </div>
                <div class="col-lg-2">
                    <label class="form-label"></label>
                    <div class="field-set"><?php echo $frmSearch->getFieldHTML('btn_submit'); ?></div>
                </div>
                <div class="col-lg-2">
                    <label class="form-label"></label>
                    <div class="field-set"><?php echo $frmSearch->getFieldHTML('btn_clear'); ?></div>
                </div>
            </div>
            <div class='dvFocus-js'></div>
            </form>
            <?php echo $frmSearch->getExternalJS(); ?>
        </div>
        <div class="content-body">
            <div class="row">
                <div class="col-md-6 mb-3 mb-md-0">
                    <div class="card" id="listing">
                        <?php echo Labels::getLabel('LBL_Loading..', $siteLangId); ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body h-100">
                            <div id="dvForm"></div>
                            <div class="alert-aligned" id="dvAlert">
                                <div class="cards-message">
                                    <div class="cards-message-icon"><i class="fas fa-exclamation-triangle"></i></div>
                                    <div class="cards-message-text">
                                        <?php echo Labels::getLabel('LBL_Select_a_product_to_add_/_edit_meta_tags_data', $siteLangId); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>