<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="scroll scroll-x js-scrollable table-wrap">
    <?php
    $arr_flds = array(
        'listserial' => Labels::getLabel('LBL_#', $siteLangId),
        'product_identifier' => Labels::getLabel('LBL_Product', $siteLangId),
        //'attrgrp_name' => Labels::getLabel('LBL_Attribute_Group', $siteLangId),
        'product_model' => Labels::getLabel('LBL_Model', $siteLangId),
        'product_active' => Labels::getLabel('LBL_Status', $siteLangId),
        'product_approved' => Labels::getLabel('LBL_Admin_Approval', $siteLangId)
    );
    $isCustom = (isset($postedData['type'])) ? $postedData['type'] : 0;
    if ($canEdit && $canEditShipProfile && 1 > $isCustom && FatApp::getConfig('CONF_SHIPPED_BY_ADMIN_ONLY', FatUtility::VAR_INT, 0) == 0 && ALLOW_SALE > 0) {
        $arr_flds['product_shipped_by'] = Labels::getLabel('LBL_Self_Shipment(For_Sale)', $siteLangId);
    }
    $tableClass = '';
    if (0 < count($arr_listing)) {
        $tableClass = "table-justified";
    }
    $arr_flds['action'] = '';
    $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table ' . $tableClass));
    $th = $tbl->appendElement('thead')->appendElement('tr', array('class' => ''));
    foreach ($arr_flds as $val) {
        $e = $th->appendElement('th', array(), $val);
    }

    $sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;

    foreach ($arr_listing as $sn => $row) {
        $tr = $tbl->appendElement('tr', array('class' => ''));

        foreach ($arr_flds as $key => $val) {
            $td = $tr->appendElement('td');
            switch ($key) {
                case 'listserial':
                    $td->appendElement('plaintext', array(), $sr_no, true);
                    break;
                case 'product_identifier':
                    $html = '<div class="product-profile"><figure class="product-profile-thumbnail" '.HtmlHelper::profileImgAttr().'><img src="' . UrlHelper::getCachedUrl(CommonHelper::generateUrl('image', 'product', array($row['product_id'], "SMALL", 0, 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg') . '" title="' . $row['product_name'] . '" alt="' . $row['product_name'] . '"></figure>
					<div class="product-profile-data">
						<div class="product-profile-title">' . $row['product_name'] . '</div>
						<div class="product-profile-brand"> (' . $row[$key] . ') </div>
					</div></div>';
                    $td->appendElement('plaintext', array(), $html, true);
                    break;
                /* case 'attrgrp_name':
              $td->appendElement('plaintext', array(), CommonHelper::displayNotApplicable($siteLangId, $row[$key]), true);
              break; */
                case 'product_approved':
                    $td->appendElement('span', array('class' => 'badge badge-inline ' . $approveUnApproveClassArr[$row[$key]]), $approveUnApproveArr[$row[$key]] . '<br>', true);
                    break;
                case 'product_active':
                    $td->appendElement('span', array('class' => 'badge badge-inline ' . $activeInactiveClassArr[$row[$key]]), $activeInactiveArr[$row[$key]] . '<br>', true);
                    break;
                case 'product_shipped_by':
                    $active = "";
                    if ($row['psbs_user_id']) {
                        $active = 'checked';
                    }

                    $str = Labels::getLabel('LBL_N/A', $siteLangId);
                    if (!$row['product_seller_id']) {
                        $statucAct = (!$row['psbs_user_id']) ? 'setShippedBySeller(' . $row['product_id'] . ')' : 'setShippedByAdmin(' . $row['product_id'] . ')';

                        $str = '<label class="switch switch-sm switch-icon" for="switch' . $row['product_id'] . '"><input ' . $active . ' type="checkbox" id="switch' . $row['product_id'] . '" onclick="' . $statucAct . '"/></label>';
                    }
                    $td->appendElement('plaintext', array(), $str, true);
                    break;
                case 'action':
                    $canAddToStore = true;
                    if ($row['product_approved'] == applicationConstants::NO) {
                        $canAddToStore = false;
                    }
                    $available = Product::availableForAddToStore($row['product_id'], $userParentId);
                    $ul = $td->appendElement("ul", array('class' => 'actions'), '', true);
                    if ($canEdit) {
                        if ($available && $canAddToStore) {
                            $li = $ul->appendElement("li", array("class" => "actions-item"));
                            $li->appendElement(
                                'button',
                                array('type' => 'button', 'class' => ($canAddToStore) ? 'icn-highlighted actions-link' : 'icn-highlighted disabled actions-link', 'onClick' => 'checkIfAvailableForInventory(' . $row['product_id'] . ')', 'title' => Labels::getLabel('LBL_Add_To_Store', $siteLangId), true),
                                '<i class="fa fa-plus-square"></i>',
                                true
                            );
                        }

                        if (0 != $row['product_seller_id']) {
                            $li = $ul->appendElement("li", array("class" => "actions-item"));
                            $li->appendElement('a', array('class' => 'actions-link', 'title' => Labels::getLabel('LBL_Edit', $siteLangId), "href" => UrlHelper::generateUrl('seller', 'customProductForm', array($row['product_id']))), '<i class="fa fa-edit"></i>', true);

                            $li = $ul->appendElement("li", array("class" => "actions-item"));
                            $li->appendElement("button", array('class' => 'actions-link', 'title' => Labels::getLabel('LBL_Product_Images', $siteLangId), 'onclick' => 'customProductImages(' . $row['product_id'] . ')'), '<i class="fas fa-images"></i>', true);
                        }

                        if ($canEditShipProfile && $row['product_added_by_admin_id'] && $row['psbs_user_id'] && $row['product_type'] == Product::PRODUCT_TYPE_PHYSICAL) {
                            $li = $ul->appendElement("li", array("class" => "actions-item"));
                            $li->appendElement("button", array('class' => 'actions-link', 'title' => Labels::getLabel('LBL_Edit_Shipping', $siteLangId), 'onclick' => 'sellerShippingForm(' . $row['product_id'] . ')'), '<i class="fa fa-truck"></i>', true);
                        }

                        $hasInventory = Product::hasInventory($row['product_id'], UserAuthentication::getLoggedUserId());
                        if ($hasInventory) {
                            $actionUrl = (isset($_SESSION['request_from_page']) && $_SESSION['request_from_page'] == applicationConstants::PRODUCT_FOR_SALE) ? "sales" : "products";

                            $li = $ul->appendElement("li", array("class" => "actions-item"));
                            $li->appendElement(
                                'button',
                                array('type' => 'button', 'onclick' => 'sellerProducts(' . $row['product_id'] . ', "' . $actionUrl . '")', 'class' => 'actions-link', 'title' => Labels::getLabel('LBL_View_Inventories', $siteLangId), true),
                                '<i class="fas fa-clipboard-list"></i>',
                                true
                            );
                        }
                    }

                    $li = $ul->appendElement("li", array("class" => "actions-item"));
                    $li->appendElement(
                        'button',
                        array('type' => 'button', 'onclick' => 'catalogInfo(' . $row['product_id'] . ')', 'class' => 'actions-link', 'title' => Labels::getLabel('LBL_product_Info', $siteLangId), true),
                        '<i class="fa fa-eye"></i>',
                        true
                    );

                    break;
                default:
                    $td->appendElement('plaintext', array(), $row[$key], true);
                    break;
            }
        }

        $sr_no--;
    }
    echo $tbl->getHtml();
    if (count($arr_listing) == 0) {
        $message = Labels::getLabel('LBL_Searched_product_is_not_found_in_catalog', $siteLangId);
        $linkArr = array();
        /* if (User::canAddCustomProductAvailableToAllSellers()) {
          $linkArr = array(
          0 => array(
          'href' => UrlHelper::generateUrl('Seller', 'CustomCatalogProductForm'),
          'label' => Labels::getLabel('LBL_Request_New_Product', $siteLangId),
          )
          );
          } */
        $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'linkArr' => $linkArr, 'message' => $message));
    }

    if (!isset($postedData['type']) || '' == $postedData['type']) {
        $postedData['type'] = -1;
    }
    ?>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmCatalogProductSearchPaging'));

$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'callBackJsFunc' => 'goToCatalogProductSearchPage', 'siteLangId' => $siteLangId, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'removePageCentClass' => true);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);