<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="card-head card-head-sub">
    <h5 class="card-title">
        <button type="button" class="btn btn-back" onClick="shopCollections(this)">
            <svg class="svg" width="24" height="24">
                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                </use>
            </svg>
        </button>
        <?php echo Labels::getLabel('LBL_Back_to_Collections', $siteLangId); ?></button>
    </h5>
</div>
<div class="card-body">
    <div class="col-lg-12 col-md-12">
        <div class="tabs-content">
            <div class="row ">
                <div class="col-md-12">
                    <ul class="nav nav-tabs tabs-grcustom navTabsJs">
                        <?php $inactive = ($scollection_id == 0) ? 'fat-inactive' : ''; ?>
                        <li class="nav-item is-active"><button type="button" class="nav-link" onclick="getShopCollectionGeneralForm(<?php echo $scollection_id; ?>);"><?php echo Labels::getLabel('TXT_Basic', $siteLangId); ?></button></li>
                        <li class="nav-item <?php echo (0 == $scollection_id) ? 'fat-inactive' : ''; ?>">
                            <button class="nav-link" <?php echo (0 < $scollection_id) ? "onclick='editShopCollectionLangForm(" . $scollection_id . "," . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . ");'" : ""; ?>>
                                <?php echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
                            </button>
                        </li>
                        <li class="nav-item <?php echo $inactive; ?>"><button type="button" class="nav-link" <?php if ($scollection_id > 0) { ?> onclick="sellerCollectionProducts(<?php echo $scollection_id; ?>);" <?php } ?>><?php echo Labels::getLabel('TXT_LINK', $siteLangId); ?></button></li>
                        <li class="nav-item <?php echo $inactive; ?>"><button type="button" class="nav-link" <?php if ($scollection_id > 0) { ?> onclick="collectionMediaForm(this, <?php echo $scollection_id; ?>);" <?php } ?>><?php echo Labels::getLabel('TXT_Media', $siteLangId); ?></button></li>
                    </ul>
                    <div class="row form__subcontent">
                        <div class="col-lg-12 col-md-12">
                            <?php
                            $colectionForm->setFormTagAttribute('class', 'form form--horizontal');
                            $colectionForm->setFormTagAttribute('onsubmit', 'setupShopCollection(this); return(false);');
                            $colectionForm->developerTags['colClassPrefix'] = 'col-lg-4 ';
                            $colectionForm->developerTags['fld_default_col'] = 4;
                            $urlFld = $colectionForm->getField('urlrewrite_custom');
                            $urlFld->setFieldTagAttribute('id', "urlrewrite_custom");
                            $urlFld->setFieldTagAttribute('onkeyup', "getSlugUrl(this,this.value,'" . $baseUrl . "','post')");
                            $collectionUrl = "";
                            if (0 < $scollection_id) {
                                $collectionUrl = UrlHelper::generateFullUrl('Shops', 'Collection', array($shop_id, $scollection_id));
                            }
                            $urlFld->htmlAfterField = "<small class='form-text text-muted'>" . $collectionUrl . '</small>';
                            $IDFld = $colectionForm->getField('scollection_id');
                            $IDFld->setFieldTagAttribute('id', "scollection_id");
                            $identiFierFld = $colectionForm->getField('scollection_identifier');
                            $identiFierFld->setFieldTagAttribute('onkeyup', "Slugify(this.value,'urlrewrite_custom','scollection_id')");

                            $submitFld = $colectionForm->getField('btn_submit');
                            $submitFld->setFieldTagAttribute('class', "btn btn-brand btn-wide");
                            echo $colectionForm->getFormHtml();
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
