<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
foreach ($images as $image) {
    $uploadedTime = AttachedFile::setTimeParam($image['afile_updated_at']);
    $imgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($image['afile_record_id'], 'THUMB', 0, $image['afile_id'], $image['afile_lang_id'], $image['afile_type']), CONF_WEBROOT_FRONTEND) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
    if ($isDefaultLayout == applicationConstants::YES) {
        ?>
        <li id="<?php echo $image['afile_id']; ?>">
            <div class="uploaded-stocks-item" data-ratio="1:1">
                <img class="uploaded-stocks-img" data-bs-toggle="tooltip" data-placement="top" src="<?php echo $imgUrl; ?>"
                    title="<?php echo $image['afile_name']; ?>" alt="<?php echo $image['afile_name']; ?>">
                <div class="uploaded-stocks-actions">
                    <?php if ($canEdit) { ?>
                        <ul class="actions">
                            <li class="actions-item">
                                <a class="actions-link" href="javascript:void(0)"
                                    onclick="deleteImage(<?php echo $image['afile_record_id']; ?>, <?php echo $image['afile_id']; ?>, <?php echo $image['afile_type']; ?>, 0, '<?php echo $isTempImg; ?>', '<?php echo $isDefaultLayout; ?>');">
                                    <svg class="svg" width="18" height="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                        fill="currentColor">
                                        <path
                                            d="M17 6H22V8H20V21C20 21.5523 19.5523 22 19 22H5C4.44772 22 4 21.5523 4 21V8H2V6H7V3C7 2.44772 7.44772 2 8 2H16C16.5523 2 17 2.44772 17 3V6ZM18 8H6V20H18V8ZM9 4V6H15V4H9Z">
                                        </path>
                                    </svg>
                                </a>
                            </li>
                        </ul>
                    <?php } ?>
                </div>
            </div>
        </li>
    <?php } else { ?>
        <li id="<?php echo $image['afile_id']; ?>" class="uploaded-media-item ">
			<div class=" uploaded-file">
				<div class="uploaded-file-thumb ">
					<img src="<?php echo $imgUrl; ?>" title="<?php echo $image['afile_name']; ?>" alt="<?php echo $image['afile_name']; ?>">

				</div> 
				<?php if ($canEdit) { ?>		
					<button type="button" class="btn-close text-reset file-remove" onclick="deleteImage(<?php echo $image['afile_record_id']; ?>, <?php echo $image['afile_id']; ?>, <?php echo $image['afile_type']; ?>, 0, '<?php echo $isTempImg; ?>', '<?php echo $isDefaultLayout; ?>');"></button>
				<?php } ?>
			</div>
        </li>

    <?php }
}

if ($isDefaultLayout == applicationConstants::YES) {
    for ($i = 0; $i < (4 - count($images)); $i++) {
        ?>
        <li class="unsortableJs">
            <div class="uploaded-stocks-item" data-ratio="1:1">
                <img class="uploaded-stocks-img" data-bs-toggle="tooltip" data-placement="top"
                    src="<?php echo CONF_WEBROOT_FRONTEND; ?>images/defaults/product_default_image.jpg" title="" alt="">
                <div class="uploaded-stocks-actions">
                </div>
            </div>
        </li>
        <?php
    }
}

if ($isDefaultLayout == applicationConstants::NO && count($images)) {
    ?>
    <script type="text/javascript">
        $(function () {
            $("#productImagesJs").sortable({
                helper: fixWidthHelper,
                start: fixPlaceholderStyle,
                stop: function () {
                    var mysortarr = new Array();
                    $(this).find('li').each(function () {
                        mysortarr.push($(this).attr("id"));
                    });

                    var sort = mysortarr.join('-');
                    var lang_id = $('.language-js').val();
                    var product_id = $('#image_product_id').val();
                    var option_id = $('#image_option_id').val();
                    var file_type = $('#image_file_type').val();
                    fcom.updateWithAjax(fcom.makeUrl('Seller', 'setCustomProductImagesOrder'), {
                        product_id,
                        file_type,
                        ids: sort
                    }, function () { });
                }
            }).disableSelection();
        });
    </script>

<?php } elseif ($isDefaultLayout == applicationConstants::YES && count($images)) {
    ?>
    <script type="text/javascript">
        $(function () {
            $("#productDefaultImagesJs").sortable({
                helper: fixWidthHelper,
                start: fixPlaceholderStyle,
                items: "li:not(.unsortableJs)",
                stop: function () {
                    var mysortarr = new Array();
                    $(this).find('li').each(function () {
                        mysortarr.push($(this).attr("id"));
                    });

                    var sort = mysortarr.join('-');
                    var lang_id = $('.language-js').val();
                    var product_id = $('#hiddenMediaFrmJs').find('[name="product_id"]').val();
                    var option_id = 0;
                    var file_type = $('#hiddenMediaFrmJs').find('[name="file_type"]').val();
                    fcom.updateWithAjax(fcom.makeUrl('Seller', 'setCustomProductImagesOrder'), {
                        product_id,
                        file_type,
                        ids: sort
                    }, function () { });
                }
            }).disableSelection();
        });
    </script>


    <?php
} ?>