<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$layout = Language::getLayoutDirection($langId);
$isAutoComplete = (!empty(FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, ''))) ? 1 : 0;

$arr_flds = array(
    'prodspec_identifier' => Labels::getLabel('LBL_Identifier', $siteLangId),
    'prodspec_name' => Labels::getLabel('LBL_File_Title', $siteLangId),
    'prodspec_file' => Labels::getLabel('LBL_File', $siteLangId),
    'action' => ''
);

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    //if ($key == 'prodspec_name') {
        //$e = $th->appendElement('th', array('width' => '50%'), $val);
    //} else {
        $e = $th->appendElement('th', array(), $val);
    //}
}
$tbody = $tbl->appendElement('tbody');
$count = 0;

if (count($productSpecifications) > 0) {
    foreach ($productSpecifications as $specification) {
        $prodSpecId = $specification['prodspec_id'];
        $tr = $tbody->appendElement('tr', ['data-id' => $prodSpecId, 'data-nfid' => 0]);
        foreach ($arr_flds as $key => $val) {
            if('action' == $key) {
                $tdAttr = ['class' => 'align-right'];
            } else if ('prodspec_identifier' == $key) {
                $tdAttr = ['class' => 'text-break'];
            } else {
                $tdAttr = ['class' => str_replace(ProdSpecification::DB_TBL_PREFIX, '', $key) . "Js text-break"];
            }
            //$tdAttr = ('action' == $key) ? ['class' => 'align-right'] : ['class' => str_replace(ProdSpecification::DB_TBL_PREFIX, '', $key) . "Js text-break"];
            $td = $tr->appendElement('td', $tdAttr);
            switch ($key) {
                case 'prodspec_file':
                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE, $productId, $prodSpecId, $langId);
                    $fileHtml = '';
                    if (!empty($fileData) && $fileData['afile_id'] > 0) {
                        $tr->addValueToAttribute('data-ofid', $fileData['afile_id']);
                        $fileArr = explode('.', $fileData['afile_name']);
                        //$fileType = strtolower($fileArr[1]);
                        $fileTypeIndex = count($fileArr) - 1;
                        $fileType = strtolower($fileArr[$fileTypeIndex]);
                        $imageTypes = array('gif', 'jpg', 'jpeg', 'png', 'svg', 'bmp', 'tiff');

                        $attachmentUrl = CommonHelper::generateFullUrl('image', 'productSpecFile', array(AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE, $fileData['afile_record_id'], $fileData['afile_record_subid'], $fileData['afile_lang_id']), CONF_WEBROOT_FRONT_URL);
                        if (in_array($fileType, $imageTypes)) {
                            $imageSrc = CommonHelper::generateFullUrl('image', 'productSpecFile', array(AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE, $fileData['afile_record_id'], $fileData['afile_record_subid'], $fileData['afile_lang_id'], 50, 50), CONF_WEBROOT_FRONT_URL) . AttachedFile::setTimeParam($fileData['afile_updated_at']);
                            $fileHtml = "<a href='" . $attachmentUrl . "' target='_blank' title='" . $fileData['afile_name'] . "'><img src='" . $imageSrc . "' class='img-thumbnail image-small' /> </a>";
                        } else {
                            $fileHtml = "<a href='" . $attachmentUrl . "' title='" . $fileData['afile_name'] . "' download><i class='fa fa-download' aria-hidden='true'></i></a>";
                        }
                    }
                    $td->appendElement('plaintext', array(), $fileHtml, true);

                    break;
                case 'prodspec_name':
                    $identifier = $specName = '';
                    if($specification['prodspec_identifier'] != '') {
                        $identifier = html_entity_decode($specification['prodspec_identifier'], ENT_QUOTES, 'utf-8');
                    }
                    if($specification[$key] != '') {
                        $specName = html_entity_decode($specification[$key], ENT_QUOTES, 'utf-8');
                    }
                    
                    $inputIdentifier = new HtmlElement(
                        'input',
                        [
                            'name' => 'fspecifications[' . $count . '][identifier]',
                            'type' => 'hidden',
                            'value' => $identifier,
                            'data-fatreq' => json_encode(['required' => false]),
                            'class' => 'identifierJs'
                        ]
                    );
                    $input = new HtmlElement(
                        'input',
                        [
                            'name' => 'fspecifications[' . $count . '][' . str_replace(ProdSpecification::DB_TBL_PREFIX, '', $key) . ']',
                            'type' => 'hidden',
                            'value' => $specName,
                            'data-fatreq' => json_encode(['required' => false]),
                        ]
                    );
                    $td->appendElement('plaintext', $tdAttr, $specification[$key] . $input->getHtml() . $inputIdentifier->getHtml(), true);
                    break;
                case 'action':
                    $ul = $td->appendElement('ul', array('class' => 'actions'));
                    $li = $ul->appendElement('li', array('class' => 'actions-item'));
                    $li->appendElement(
                        'input',
                        [
                            'name' => 'fspecifications[' . $count . '][id]',
                            'type' => 'hidden',
                            'value' => $specification['prodspec_id'],
                            'data-fatreq' => json_encode(['required' => false]),
                        ]
                    );
                    $li->appendElement(
                        'a',
                        [
                            'href' => 'javascript:void(0)',
                            'title' => Labels::getLabel('BTN_EDIT', $langId),
                            'onclick' => "editFileSpec(this)",
                            'class' => "actions-link",
                        ],
                        '<i class="fa fa-edit"></i>',
                        true
                    );
    
                    $li = $ul->appendElement('li', array('class' => 'actions-item'));
                    $li->appendElement(
                        'a',
                        [
                            'href' => 'javascript:void(0)',
                            'title' => Labels::getLabel('BTN_DELETE', $langId),
                            'onclick' => "deleteFileSpec(this)",
                            'data-id' => $prodSpecId,
                            'data-lang-id' => $langId,
							'class' => "actions-link",
                        ],
                        '<i class="fa fa-trash"></i>',
                        true
                    );
                    break;
                default:
                    $td->appendElement('plaintext', array(), $specification[$key], true);
                    break;
            }
        }
        $count = 0;
    }
} ?>

<div class="js-scrollable table-wrap table-responsive">
    <?php echo $tbl->getHtml(); ?>
</div>