<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="content-wrapper content mainJs" <?php echo CommonHelper::getLayoutDirection() != $formLayout ? 'dir="' . $formLayout . '"' : ''; ?>>
    <div class="content-header row">
        <div class="col">
            <div class="content-header-title">
                <h2>
                    <?php echo Labels::getLabel('LBL_Custom_Product_Setup', $siteLangId); ?>
                </h2>
            </div>
        </div>
        <div class="col-auto">
            <div class="btn-group">
                <?php if (strtolower($previousAction) == 'catalog') { ?>
                    <a href="<?php echo UrlHelper::generateUrl('seller', 'catalog'); ?>"
                        class="btn btn-outline-brand btn-sm"><?php echo Labels::getLabel('LBL_Back_To_My_Products', $siteLangId); ?></a>
                <?php } else { ?>
                    <a href="<?php echo UrlHelper::generateUrl('sellerInventories', 'products'); ?>"
                        class="btn btn-outline-brand btn-sm"><?php echo Labels::getLabel('LBL_Back_To_Inventory', $siteLangId); ?></a>
                <?php } ?>
                </a>
            </div>
        </div>
    </div>
    <div class="content-body">
        <!-- New Form Start -->
        <?php $frm->addFormTagAttribute('class', 'form');
        $frm->setFormTagAttribute('id', 'addProductfrm');
        $frm->setFormTagAttribute('onsubmit', 'setup($(\'#addProductfrm\'));return false;');
        echo $frm->getFormTag(); ?>
        <div class="add-stock" id="addStock">
            <div class="add-stock-column column-main">
                <div class="card" id="basic-details">
                    <div class="card-head">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('LBL_BASIC_DETAILS', $siteLangId); ?>
                            </h3>
                            <span
                                class="text-muted"><?php echo Labels::getLabel('LBL_MANAGE_PRODUCT_BASIC_INFORMATION', $siteLangId); ?></span>
                        </div>
                        <?php
                        $langFld = $frm->getField('lang_id');
                        if (1 > $preqId) {
                            $langFld->addFieldTagAttribute('disabled', 'disabled');
                        } else {
                            $langFld->setfieldTagAttribute('class', 'form-control form-select select-language');
                            $langFld->setfieldTagAttribute('onchange', 'langForm()');
                            $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
                            if (!empty($translatorSubscriptionKey) && $siteLangId != CommonHelper::getDefaultFormLangId()) {
                                $langFld->developerTags['fldWidthValues'] = ['d-flex', '', '', ''];
                                $langFld->htmlAfterField = '<div class="input-group-append">
                                                                        <a href="javascript:void(0);"  class="btn xxx" onclick="langForm(' . $siteLangId . ',1)" class="btn" title="' . Labels::getLabel('BTN_AUTOFILL_LANGUAGE_DATA', $siteLangId) . '">
                                                                            <svg class="svg" width="18" height="18">
                                                                                <use xlink:href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#icon-translate">
                                                                                </use>
                                                                            </svg>
                                                                        </a>
                                                                    </div>';
                            }
                        }

                        ?>
                        <div class="content-header-toolbar">
                            <div class="input-group">
                                <?php
                                echo $langFld->getHtml();
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <?php echo HtmlHelper::getFieldHtml($frm, 'product_identifier', 12, [], Labels::getLabel('MSG_A_UNIQUE_IDENTIFIER_ASSOCIATED_FOR_PRODUCT_NAME', $siteLangId));

                            echo HtmlHelper::getFieldHtml($frm, 'product_name', 12, [], Labels::getLabel('MSG_A_NAME_OF_THE_PRODUCT_TO_BE_LISTED', $siteLangId));

                            echo HtmlHelper::getFieldHtml($frm, 'brand_name', 6, ['onChange' => 'brandAutocomplete(this)', 'id' => 'brand_name'], '', '', ['label' => FatApp::getConfig('CONF_BRAND_REQUEST_APPROVAL', FatUtility::VAR_INT, 0) ? Labels::getLabel('FRM_REQUEST_FOR_BRAND', $siteLangId) : Labels::getLabel('FRM_ADD_BRAND', $siteLangId), 'attr' => ['href' => 'javascript:void(0)', 'onclick' => 'addBrandReqForm(0)', 'class' => 'link']]);

                            echo HtmlHelper::getFieldHtml($frm, 'model_name', 6, ['id' => 'model_name']);

                            echo HtmlHelper::getFieldHtml($frm, 'category_name', 6, ['onChange' => 'categoryAutocomplete(this)', 'id' => 'category_name'], '', '', ['label' => FatApp::getConfig('CONF_PRODUCT_CATEGORY_REQUEST_APPROVAL', FatUtility::VAR_INT, 0) ? Labels::getLabel('FRM_REQUEST_FOR_CATEGORY', $siteLangId) : Labels::getLabel('FRM_ADD_CATEGORY', $siteLangId), 'attr' => ['href' => 'javascript:void(0)', 'onclick' => 'addCategoryReqForm(0)', 'class' => 'link']]);
                            echo HtmlHelper::getFieldHtml($frm, 'product_model', 6);
                            if ($allowForSale) {
                                echo HtmlHelper::getFieldHtml($frm, 'product_min_selling_price', 6);
                            }

                            echo HtmlHelper::getFieldHtml($frm, 'taxcat_name', 6, ['id' => 'taxcat_name'], '', '', ['label' => Labels::getLabel('FRM_TAX_CATEGORIES', $siteLangId), 'attr' => ['target' => '__blank', 'href' => UrlHelper::generateUrl('Seller', 'taxCategories'), 'class' => 'link']]);

                            echo HtmlHelper::getFieldHtml($frm, 'taxcat_name_rent', 6, ['id' => 'taxcat_name_rent'], '', '', ['label' => Labels::getLabel('FRM_TAX_CATEGORIES', $siteLangId), 'attr' => ['target' => '__blank', 'href' => UrlHelper::generateUrl('seller', 'taxCategories'), 'class' => 'link']]);
                            echo HtmlHelper::getFieldHtml($frm, 'product_warranty', 6, [], Labels::getLabel('MSG_Warranty_In_Days', $siteLangId));

                            echo HtmlHelper::getFieldHtml($frm, 'product_youtube_video', 12);
                            echo HtmlHelper::getFieldHtml($frm, 'product_description', 12);
                            ?>
                        </div>
                    </div>
                </div>
                <div class="card card-toggle" id="media">
                    <div class="card-head dropdown-toggle-custom collapsed" data-toggle="collapse"
                        data-target="#stock-block2" aria-expanded="false" aria-controls="stock-block2">
                        <div class="card-head-label">
                            <h3 class="card-head-title"><?php echo Labels::getLabel('NAV_MEDIA', $siteLangId); ?> </h3>
                            <span
                                class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_YOUR_PRODUCT_IMAGES_GALLERY', $siteLangId); ?>
                            </span>
                        </div>
                        <div class="card-toolbar">
                            <i class="dropdown-toggle-custom-arrow"></i>
                        </div>
                    </div>
                    <div class="collapse" id="stock-block2">
                        <div class="card-body">
                            <div>
                                <div class="d-flex justify-content-between mb-3">
                                    <h6 class="h6 "><?php echo Labels::getLabel('LBL_UPLOADED_MEDIA', $siteLangId); ?>
                                    </h6>
                                    <a class="link-underline" href="javascript:void(0)"
                                        onclick="imageForm();"><?php echo Labels::getLabel('LBL_ADVANCED_MEDIA', $siteLangId); ?></a>
                                </div>
                                <ul class="uploaded-stocks ui-sortable" id="productDefaultImagesJs">
                                    <li class="browse unsortableJs">
                                        <button type="button" class="browse-button"
                                            onclick="$('#hiddenMediaFrmFileJs').click();">
                                            <strong><?php echo Labels::getLabel('LBL_UPLOAD_IMAGES(S)', $siteLangId); ?></strong>
                                            <span
                                                class="text-muted form-text"><?php echo Labels::getLabel('MSG_PNG,JPEG_ACCEPTED', $siteLangId); ?></span>
                                        </button>
                                    </li>
                                </ul>
                                <div class="form-text text-muted pt-2">
                                    <?php #echo sprintf(Labels::getLabel('LBL_Preferred_Dimensions_%s', $siteLangId), $imgFrm->getField('min_width')->value . ' x ' . $imgFrm->getField('min_height')->value); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card card-toggle" id="specifications">
                    <div class="card-head dropdown-toggle-custom collapsed" data-toggle="collapse"
                        data-target="#specifications-block" aria-expanded="false" aria-controls="specifications-block">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('NAV_SPECIFICATIONS', $siteLangId); ?>
                            </h3>
                            <span
                                class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_PRODUCT_RELATED_SPECIFICATIONS', $siteLangId); ?>
                            </span>
                        </div>
                        <div class="card-toolbar"> <i class="dropdown-toggle-custom-arrow"></i></div>
                    </div>
                    <div class="collapse" id="specifications-block">
                        <div class="card-body">
                            <div id="specificationsFormJs">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_IDENTIFIER', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="sp_identifier" id="sp_identifier" value=""
                                                data-required="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_NAME', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="sp_label" id="sp_label" value="" data-required="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_VALUE', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="sp_value" id="sp_value" value="" data-required="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_GROUP', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="sp_group" id="sp_group" value="" data-required="0">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label"></label>
                                            <input type="hidden" name="sp_id" id="sp_id" value="0" data-required="0">
                                            <button type="button" id="btnAddSpecJs" class="btn btn-brand btn-wide"
                                                onclick="addSpecification()"
                                                data-updateLbl="<?php echo Labels::getLabel('BTN_UPDATE', $siteLangId); ?>"
                                                data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>">
                                                <?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>
                                            </button>
                                            <button type="button" id="btnClearSpecJs"
                                                class="btn btn-outline-brand btn-wide" onclick="clearProdSpecForm()"
                                                data-updateLbl="<?php echo Labels::getLabel('BTN_UPDATE', $siteLangId); ?>"
                                                data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>">
                                                <?php echo Labels::getLabel('BTN_CLEAR', $siteLangId); ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="specificationsListSeprJs" class="separator separator-dashed my-4"></div>
                            <div id="specificationsListJs"></div>
                        </div>
                    </div>
                </div>
                <div class="card card-toggle" id="file-specifications">
                    <div class="card-head dropdown-toggle-custom collapsed" data-toggle="collapse"
                        data-target="#file-specifications-block" aria-expanded="false"
                        aria-controls="file-specifications-block">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('NAV_FILE_SPECIFICATIONS', $siteLangId); ?>
                            </h3>
                            <span
                                class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_PRODUCT_RELATED_FILE_SPECIFICATIONS', $siteLangId); ?>
                            </span>
                        </div>
                        <div class="card-toolbar"> <i class="dropdown-toggle-custom-arrow"></i></div>
                    </div>
                    <div class="collapse" id="file-specifications-block">
                        <div class="card-body">
                            <div id="file-specificationsFormJs">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_IDENTIFIER', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="fsp_identifier" id="fsp_identifier" value=""
                                                data-required="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_NAME', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="fsp_name" id="fsp_name" value="" data-required="1">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <span
                                                    class="filename"><?php echo Labels::getLabel('LBL_Specification_File_Is_Mandatory', $siteLangId); ?></span>
                                            </label>
                                            <input id="hiddenSpecFileFrmFileJs" accept="image/*"
                                                data-name="<?php echo Labels::getLabel("FRM_SPECIFICATION_FILE", $siteLangId); ?>"
                                                data-ids="prodspec_file" type="file" data-frm="fileSpecFrm"
                                                name="prodspec_file" onChange="uploadFileSpecFile(this);">
                                            <div id="filespectempJs"></div>
                                            <!-- <input id="hiddenSpecFileIndexJs" data-is_file="1" type="hidden" id="hiddenSpecFileIndexJs" name="prodspec_file_index"  data-required="1"> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label"></label>
                                            <input type="hidden" name="file_index" id="file_index" value="0"
                                                data-required="0">
                                            <input type="hidden" name="ofile_index" id="ofile_index" value="0"
                                                data-required="0">
                                            <button type="button" id="btnAddFileSpecJs" class="btn btn-brand btn-wide"
                                                onclick="addFileSpecification()"
                                                data-updatelbl="<?php echo Labels::getLabel('BTN_UPDATE', $siteLangId); ?>"
                                                data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>">
                                                <?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>
                                            </button>
                                            <button type="button" id="btnClearFileSpecJs"
                                                class="btn btn-outline-brand btn-wide" onclick="clearFileSpecForm()"
                                                data-updateLbl="<?php echo Labels::getLabel('BTN_UPDATE', $siteLangId); ?>"
                                                data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>">
                                                <?php echo Labels::getLabel('BTN_CLEAR', $siteLangId); ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="file-specificationsListSeprJs" class="separator separator-dashed my-4"></div>
                            <div id="file-specificationsListJs"></div>
                        </div>
                    </div>
                </div>
                <div class="card card-toggle" id="tax-shipping">
                    <div class="card-head dropdown-toggle-custom" data-toggle="collapse" data-target="#stock-block4"
                        aria-expanded="true" aria-controls="stock-block4">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('NAV_SHIPPING_INFORMATION', $siteLangId); ?>
                            </h3>
                            <span class="text-muted">
                                <?php echo Labels::getLabel('MSG_SETUP_SHIPPING_INFORMATION_OF_THE_PRODUCT', $siteLangId); ?>
                            </span>
                        </div>
                        <div class="card-toolbar"> <i class="dropdown-toggle-custom-arrow"></i></div>
                    </div>
                    <div class="collapse show" id="stock-block4">
                        <div class="card-body">
                            <div class="row">
                                <?php
                                echo HtmlHelper::getFieldHtml($frm, 'product_ship_package', 6);
                                echo HtmlHelper::getFieldHtml($frm, 'shipping_profile', 6, ['id' => 'shipping_profile']);
                                echo HtmlHelper::getFieldHtml($frm, 'product_weight', 6);
                                echo HtmlHelper::getFieldHtml($frm, 'product_weight_unit', 6);
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card card-toggle disabled" id="customfields">
                    <div class="card-head dropdown-toggle-custom collapsed" data-toggle="collapse"
                        data-target="#customfields-block" aria-expanded="false" aria-controls="specifications-block">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('NAV_CUSTOM_FIELDS', $siteLangId); ?>
                            </h3>
                            <span
                                class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_PRODUCT_CUSTOM_FIELDS', $siteLangId); ?>
                            </span>
                        </div>
                        <div class="card-toolbar"> <i class="dropdown-toggle-custom-arrow"></i></div>
                    </div>
                    <div class="collapse" id="customfields-block">
                        <div class="card-body">
                            <div id="CustomFieldsFormJs"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="add-stock-column column-actions">
                <div class="sticky-top">
                    <div class="card">
                        <div class="card-body">
                            <?php
                            $fld = $frm->getField('btn_submit');
                            $fld->addFieldTagAttribute('class', 'btn btn-brand btn-block');
                            echo $frm->getFieldHtml('btn_submit');
                            echo $frm->getFieldHtml('preq_id');
                            echo $frm->getFieldHtml('temp_record_id');
                            echo $frm->getFieldHtml('ptc_prodcat_id');
                            echo $frm->getFieldHtml('product_brand_id');
                            echo $frm->getFieldHtml('product_type');
                            echo $frm->getFieldHtml('ptt_taxcat_id');
                            echo $frm->getFieldHtml('ptt_taxcat_id_rent');
                            ?>
                            <div class="mt-3">
                                <?php
                                $fld = $frm->getField('product_active');
                                HtmlHelper::configureSwitchForCheckbox($fld);
                                echo '<div class="form-group">
                                                <div class="setting-block">' . $fld->getHtml() . '</div>
                                            </div>';

                                if (0 < $preqId && $canSubmitForApproval) {
                                    echo '<div class="card">
                                                <div class="card-body">
                                                    <a href="' . UrlHelper::generateUrl('seller', 'approveCustomCatalogProducts', [$preqId]) . '" class="btn btn-brand btn-block">' . Labels::getLabel('FRM_SUBMIT_FOR_APPROVAL', $langId) . '</a>
                                                </div>
                                            </div>';
                                }

                                $fld = $frm->getField('product_featured');
                                HtmlHelper::configureSwitchForCheckbox($fld);
                                echo '<div class="form-group">
                                                <div class="setting-block">' . $fld->getHtml() . '</div>
                                            </div>';
                                /* $fld = $frm->getField('auto_update_other_langs_data');
                                if (null != $fld) {
                                HtmlHelper::configureSwitchForCheckbox($fld);
                                    echo '<div class="form-group">
                                            <div class="setting-block">' . $fld->getHtml() . '</div>
                                        </div>';
                                } */
                                $fld = $frm->getField('product_cod_enabled');
                                if (null != $fld) {
                                    $fld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');

                                    HtmlHelper::configureSwitchForCheckbox($fld);
                                    echo '<div class="form-group">
                                                    <div class="setting-block">' . $fld->getHtml() . '</div>
                                                </div>';
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    $fld = $frm->getField('product_tags');
                    if (null != $fld) {
                        $fld->addFieldTagAttribute('class', 'form-tagify');
                        $fld->addFieldTagAttribute('id', 'product_tags');
                        ?>
                        <div class="card">
                            <div class="card-head">
                                <div class="card-head-label">
                                    <h3 class="card-head-title">Tags</h3>
                                    <span class="text-muted">
                                        <?php echo Labels::getLabel('FRM_BIND_TAGS_TO_MAKE_IT_EASIER_TO_APPEAR_IN_SEARCH_RESULTS', $langId); ?>
                                    </span>
                                </div>
                            </div>
                            <div class="card-body">
                                <?php echo $fld->getHtml(); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        </form>
        <?php echo $frm->getExternalJS();
        $imgFrm->setFormTagAttribute('class', 'hidden');
        $imgFrm->setFormTagAttribute('name', 'hiddenMediaFrm');
        $imgFrm->setFormTagAttribute('id', 'hiddenMediaFrmJs');
        $fld = $imgFrm->getField('prod_image');
        $fld->addFieldTagAttribute('onChange', "loadCropper(this)");
        $fld->addFieldTagAttribute('id', "hiddenMediaFrmFileJs");
        $fld->addFieldTagAttribute('data-frm', 'hiddenMediaFrm');
        $fld->addFieldTagAttribute('accept', "image/*");
        $fld->addFieldTagAttribute('data-name', Labels::getLabel("FRM_PRODUCT_IMAGE", $siteLangId));
        echo $imgFrm->getFormHtml();

        $fileSpecFrm->setFormTagAttribute('class', 'hidden');
        $fileSpecFrm->setFormTagAttribute('name', 'fileSpecFrm');
        $fileSpecFrm->setFormTagAttribute('id', 'hiddenFileSpecFrmJs');
        $fld = $fileSpecFrm->getField('prodspec_is_file');
        $fld->addFieldTagAttribute('id', 'prodspec_is_file');
        $fld = $fileSpecFrm->getField('prod_spec_file_index');
        $fld->addFieldTagAttribute('id', 'prod_spec_file_index');

        echo $fileSpecFrm->getFormHtml();
        ?>
        <!-- New Form End -->
    </div>
</div>
</main>
<script>
    var ratioTypeSquare = <?php echo AttachedFile::RATIO_TYPE_SQUARE; ?>;
    var ratioTypeRectangular = <?php echo AttachedFile::RATIO_TYPE_RECTANGULAR; ?>;
    var CONF_ALLOW_MEMBERSHIP_MODULE =
        <?php echo FatApp::getConfig('CONF_ALLOW_MEMBERSHIP_MODULE', FatUtility::VAR_INT, 0); ?>;
    var tempImageType = '<?php echo AttachedFile::FILETYPE_CUSTOM_PRODUCT_IMAGE_TEMP; ?>';
    var forAllOptionsLbl = '<?php echo Labels::getLabel('FRM_FOR_ALL_OPTIONS', $langId); ?>';
    var canEditTags = '<?php echo $canEditTags; ?>';

    $(function () {
        brandAutocomplete();
        categoryAutocomplete();
        taxCatNameRent();
        rentTaxCatNameRent();
        productDefaultImages();
        prodSpecifications();
        fileSpecifications();
        tagifyProducts();
        getCustomFields();
    });
</script>


<style>
    .disabled {
        color: #dcdcdc !important;
    }
</style>