<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frmSearch->setFormTagAttribute('class', 'form form-search');
$frmSearch->setFormTagAttribute('onsubmit', 'searchSpecialPriceProducts(this); return(false);');
$frmSearch->developerTags['colClassPrefix'] = 'col-md-';

$keywordFld = $frmSearch->getField('keyword');
$keywordFld->developerTags['col'] = 8;

if (0 < $selProd_id) {
    $keywordFld->setFieldTagAttribute('readonly', 'readonly');
}
$submitBtnFld = $frmSearch->getField('btn_submit');
$submitBtnFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block ');
$submitBtnFld->setWrapperAttribute('class', (0 < $selProd_id ? ' d-none' : ''));
$submitBtnFld->developerTags['col'] = 2;

$cancelBtnFld = $frmSearch->getField('btn_clear');
$cancelBtnFld->setFieldTagAttribute('onclick', 'clearSearch(' . $selProd_id . ');');
$cancelBtnFld->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
$cancelBtnFld->developerTags['col'] = 2;
?>
<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading"><?php echo Labels::getLabel('LBL_Seller_Products_Special_Price_List', $siteLangId); ?></h2>
                <span class="form-text text-muted">(<?php echo Labels::getLabel('LBL_Valid_Only_With_Sale_Products', $siteLangId); ?>)</span>
            </div>
        </div>
        <div class="content-form">
            <div class="form-search">
                <?php echo $frmSearch->getFormHtml(); ?>

            </div>
        </div>

        <div class="content-body">
            <div class="card">
                <div class="card-head">
                    <?php
                    if ($canEdit) {
                        foreach ($dataToEdit as $data) {
                            $data['addMultiple'] = (1 > $selProd_id) ? 1 : 0;
                            $this->includeTemplate('seller/add-special-price-form.php', array('siteLangId' => $siteLangId, 'data' => $data, 'productFor' => Product::PRODUCT_FOR_SALE), false);
                        }
                        if (1 > $selProd_id) {
                            $this->includeTemplate('seller/add-special-price-form.php', array('siteLangId' => $siteLangId, 'productFor' => Product::PRODUCT_FOR_SALE), false);
                        }
                    }
                    ?>
                </div>
                <div class="card-head">
                    <div class="card-head-toolbar">
                        <div class="links-inline">
                            <button type="button" class="btn btn-outline-gray qwer formActionBtn-js removeAll-common disabled" title="<?php echo Labels::getLabel('LBL_Delete_Special_Price', $siteLangId); ?>" onclick="deleteSpecialPriceRows()">
                                <?php echo Labels::getLabel('LBL_REMOVE', $siteLangId); ?>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-table">
                    <div id="listing">
                        <?php echo Labels::getLabel('LBL_Loading..', $siteLangId); ?>
                    </div>

                </div>
            </div>
        </div>
    </div>
</main>

<script>
    var IS_RENT_ONLY = 0;
    var IS_SALE_ONLY = 1;
</script>