<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$tagLangFrm->setFormTagAttribute('class', 'form form--horizontal layout--' . $formLayout);
$tagLangFrm->developerTags['colClassPrefix'] = 'col-lg-12 col-md-12 col-sm-';
$tagLangFrm->developerTags['fld_default_col'] = 12;
$tagLangFrm->setFormTagAttribute('onsubmit', 'setupTagLang(this); return(false);');

$langFld = $tagLangFrm->getField('lang_id');
$langFld->setfieldTagAttribute('onChange', "addTagLangForm(" . $tag_id . ", this.value);");
?>
<div class="box-head">
    <h4><?php echo Labels::getLabel('LBL_Add_Tags', $siteLangId); ?></h4>
</div>

<div class="box-body">
    <ul class="nav nav-tabs tabs-grcustom">
        <li class="nav-item">
            <button type="button" class="nav-link active" onclick="addTagForm(<?php echo $tag_id ?>);"><?php echo Labels::getLabel('LBL_Basic', $siteLangId); ?></button>
        </li>
        <?php $inactive = ($tag_id == 0) ? 'fat-inactive' : ''; ?>
        <li class="nav-item <?php echo (0 < $tag_lang_id) ? 'is-active' : '';
                            echo $inactive; ?>">
            <button type="button" class="nav-link ">
                <?php echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
            </button>
        </li>
    </ul>

    <div class="tabs-content form">
        <?php
        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        if (!empty($translatorSubscriptionKey) && $tag_lang_id != $siteDefaultLangId) { ?>
            <div class="row justify-content-end">
                <div class="col-auto mb-4">
                    <button type="button" class="btn btn-outline-gray btn-icon btn-language" title="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $siteLangId); ?>" onClick="addTagLangForm( <?php echo $tag_id; ?>, <?php echo $tag_lang_id; ?>, 1)">
                        <svg class="svg" width="24" height="24">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#translate"></use>
                        </svg>
                    </button>
                </div>
            </div>
        <?php } ?>
        <?php
        echo $tagLangFrm->getFormHtml();
        ?>
    </div>
</div>