<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$this->includeTemplate('_partial/seller/sellerDashboardNavigation.php');
$frm->setFormTagAttribute('onSubmit', 'setupProfile(this); return false;');
$frm->setFormTagAttribute('class', 'form form-search');
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 6;
$submitBtnFld = $frm->getField('btn_submit');
$submitBtnFld->setFieldTagAttribute('class', 'btn btn-brand');
$submitBtnFld->setWrapperAttribute('class', 'col-lg-2');
$submitBtnFld->developerTags['col'] = 2;
$submitBtnFld->developerTags['noCaptionTag'] = true;
?>
<main id="main-area" class="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <h2 class="content-header-heading">
                    <a class="btn btn-back" title="<?php echo Labels::getLabel('LBL_back', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('shippingProfile'); ?>">
                        <svg class="svg" width="24" height="24">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                            </use>
                        </svg>
                    </a>
                    <?php echo Labels::getLabel('LBL_Shipping_Profiles', $siteLangId); ?>
                </h2>
            </div>
        </div>
        <div class="content-form">
            <?php echo $frm->getFormTag();
            $pNameFld = $frm->getField('shipprofile_name[' . $siteDefaultLangId . ']');
            $pNameFld->htmlAfterField = "<span class='form-text text-muted'>" . Labels::getLabel("LBL_Customers_won't_see_this", $siteLangId) . "</span>";
            $pNameFld->addFieldTagAttribute('class', 'form-control');
            ?>
            <div class="row">
                <div class="col-md-8">
                    <div class="form-group mb-0">
                        <?php
                        echo $pNameFld->getHtml(); ?>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group mb-0">
                        <?php
                        echo $frm->getFieldHtml('shipprofile_id');
                        echo $frm->getFieldHtml('shipprofile_user_id');
                        echo $frm->getFieldHtml('btn_submit');
                        ?>
                    </div>
                </div>
            </div>
            <?php
            if (!empty($languages)) {
                ?>
                <div class="my-4" id="specification-accordion">
                    <button class="btn btn-gray dropdown-toggle" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapse-1" aria-expanded="true" aria-controls="collapse-1">

                        <?php
                        echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>

                    </button>
                    <div id="collapse-1" class="collapse collapse-js" aria-labelledby="headingOne"
                        data-parent="#specification-accordion">
                        <div class="p-4 mb-4 bg-gray rounded">
                            <div class="row">
                                <?php
                                foreach ($languages as $langId => $data) {
                                    if ($siteDefaultLangId == $langId) {
                                        continue;
                                    }
                                    $layout = Language::getLayoutDirection($langId);
                                    ?>
                                    <div class="col-md-12" dir="<?php echo $layout; ?>">
                                        <div class="field-set">
                                            <div class="caption-wraper">
                                                <label class="form-label">
                                                    <?php $fld = $frm->getField('shipprofile_name[' . $langId . ']');
                                                    echo $fld->getCaption();
                                                    ?>
                                                </label>
                                            </div>
                                            <div class="field-wraper">
                                                <div class="field_cover">
                                                    <?php echo $fld->getHtml(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>

                        </div>
                    </div>
                </div>
            <?php }
            ?>
            </form>
            <?php echo $frm->getExternalJs(); ?>


        </div>
        <div class="content-body">
            <div class="card mb-4" id="product-section--js"> </div>
            <?php if (empty($profileData) || ((isset($profileData['shipprofile_default'])))) { ?>
                <div class="card">
                    <div class="card-head">
                        <h5 class="card-title"><?php echo Labels::getLabel('LBL_Shipping_to', $siteLangId); ?>
                        </h5>
                        <div class="action">
                            <?php if ($canEdit) { ?>
                                <button type="button" class="btn btn-outline-gray qwer  btn-add"
                                    onClick="zoneForm(<?php echo $profile_id; ?>, 0)"
                                    title="<?php echo Labels::getLabel('LBL_ADD_ZONE', $siteLangId); ?>">
                                    <svg class="svg" width="16" height="16">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#add">
                                        </use>
                                    </svg>
                                    <?php echo Labels::getLabel('LBL_ADD', $siteLangId); ?>
                                </button>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <input type="hidden" name="profile_id" value="<?php echo $profile_id; ?>">
                        <div id="listing-zones"></div>
                    </div>
                </div>
            <?php } ?>
        </div>

    </div>

</main>