<div class="product-price">
    <?php $rentalTypeArr = applicationConstants::rentalTypeArr($siteLangId); ?>
    <?php if (isset($searchProductType) && $searchProductType == applicationConstants::PRODUCT_FOR_SALE && $product['is_sell'] && ALLOW_SALE) { ?>
        <div class="product-price-per-day">
            <?php echo CommonHelper::displayMoneyFormat($product['theprice']); ?>
            <?php if ($product['special_price_found'] && $product['selprod_price'] > $product['theprice']) { ?>
                <span class="slash">|</span>
                <del class="product-price-old">
                    <?php echo CommonHelper::displayMoneyFormat($product['selprod_price']); ?></del>
                <span
                    class="badge badge-brand label-sm "><?php echo CommonHelper::showProductDiscountedText($product, $siteLangId); ?></span>
            <?php } ?>
        </div>
    <?php } elseif ($product['is_rent']) { ?>
        <div class="product-price-per-day">
            <?php echo CommonHelper::displayMoneyFormat($product['theprice']); ?>
            <span>/ <?php echo $rentalTypeArr[$product['sprodata_duration_type']] ?? ""; ?></span>
            <?php if ($product['special_price_found'] && $product['rent_price'] > $product['theprice']) { ?>
                <span class="slash">|</span>
                <del class="product-price-old"> <?php echo CommonHelper::displayMoneyFormat($product['rent_price']); ?></del>
                <span
                    class="badge badge-brand label-sm"><?php echo CommonHelper::showProductDiscountedText($product, $siteLangId); ?></span>
            <?php } ?>
        </div>
    <?php } elseif ($product['is_sell'] && ALLOW_SALE) { ?>
        <div class="product-price-per-day">
            <?php echo CommonHelper::displayMoneyFormat($product['theprice']); ?>
            <?php if ($product['special_price_found'] && $product['selprod_price'] > $product['theprice']) { ?>
                <span class="slash">|</span>
                <del class="product-price-old">
                    <?php echo CommonHelper::displayMoneyFormat($product['selprod_price']); ?></del>
                <span
                    class="badge badge-brand label-sm "><?php echo CommonHelper::showProductDiscountedText($product, $siteLangId); ?></span>
            <?php } ?>
        </div>
    <?php } ?>
</div>
<?php if (isset($product['isListingPage']) && $product['isListingPage'] && (isset($product['prod_rating']) || (isset($product['distance']) && $product['availableForPickup']))) {
    ?>
    <div class="product-rate-info">

        <?php
        /* [ RATING DIV GOES HERE */
        if (isset($product['prod_rating'])) { ?>
            <ul class="product-rating product-rating-inline">
                <li class="product-rating-item active"></li>
                <li class="count"><?php echo round($product['prod_rating'], 1); ?></li>
            </ul>


        <?php }
        /* ] */
        /* NEED TO UPDATE UI */
        if (isset($product['distance']) && $product['availableForPickup']) { ?>
            <div class="product-distance">
                <span class="icn">
                    <svg class="svg" width="16" height="16">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#location"></use>
                    </svg>
                </span> <span
                    class="distance-count"><?php echo round($product['distance'], 0) . '</span> ' . Labels::getLabel('LBL_KM_Away', $siteLangId); ?>
            </div>
            <?php

        }
        ?>
    </div>
    <?php
} ?>