<?php defined('SYSTEM_INIT') or die('Invalid Usage');
if (($languages && count($languages) > 1) || ($currencies && count($currencies) > 1)) { ?>
            <li class="curtate-item">
                <div class="dropdown">
                    <button type="button" class="curtate-item-link dropdown-toggle no-after" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
                        <?php if ($languages[$siteLangId]['language_country_code']) { ?>
                                    <img class="icon-img" width="16" height="16" alt="<?php echo Labels::getLabel('LBL_Language_Flag', $siteLangId); ?>" src="<?php echo CONF_WEBROOT_URL; ?>images/flags/<?php echo FatApp::getConfig('CONF_COUNTRY_FLAG_TYPE', FatUtility::VAR_STRING, 'round'); ?>/<?php echo $languages[$siteLangId]['language_country_code'] . '.svg'; ?>">
                        <?php } else { ?>
                                    <svg class="svg" width="16" height="16">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#lang"></use>
                                    </svg>
                        <?php } ?>
                        <span>
                            <?php echo $languages[$siteLangId]['language_name']; ?> | <?php echo $currencies[$siteCurrencyId]; ?>
                        </span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-anim dropdown-menu-right" aria-expanded="false">
                        <div class="select-lang-currency">
                            <?php if ($languages && count($languages) > 1) { ?>
                                        <h6 class="select-lang-currency-head">
                                            <?php echo Labels::getLabel('LBL_Select_Country', $siteLangId); ?></h6>
                                        <ul class="select-lang-currency-ul">
                                            <?php foreach ($languages as $langId => $language) { ?>
                                                        <li class="select-lang-currency-item <?php echo ($siteLangId == $langId) ? ' is-active' : ''; ?>">
                                                            <button type="button" class="select-lang-currency-link" onClick="setSiteDefaultLang(<?php echo $langId; ?>)">
                                                                <?php if ($language['language_country_code']) { ?>

                                                                            <img class="icon-img" width="16" height="16" alt="<?php echo Labels::getLabel('LBL_Language_Flag', $siteLangId); ?>" src="<?php echo CONF_WEBROOT_URL; ?>images/flags/<?php echo FatApp::getConfig('CONF_COUNTRY_FLAG_TYPE', FatUtility::VAR_STRING, 'round'); ?>/<?php echo $language['language_country_code'] . '.svg'; ?>">

                                                                <?php } ?>
                                                                <?php echo ' ' . $language['language_name']; ?>
                                                            </button>
                                                        </li>
                                            <?php } ?>
                                        </ul>
                                        <?php if ($currencies && count($currencies) > 1) { ?>
                                                    <div class="space"></div>
                                        <?php } ?>
                            <?php } ?>
                            <?php if ($currencies && count($currencies) > 1) { ?>
                                        <h6 class="select-lang-currency-head">
                                            <?php echo Labels::getLabel('LBL_Select_Currency', $siteLangId); ?></h6>
                                        <ul class="select-lang-currency-ul">
                                            <?php foreach ($currencies as $currencyId => $currency) { ?>
                                                        <li class="select-lang-currency-item <?php echo ($siteCurrencyId == $currencyId) ? ' is-active' : ''; ?>">
                                                            <button type="button" class="select-lang-currency-link" onClick="setSiteDefaultCurrency(<?php echo $currencyId; ?>)"> <?php echo $currency; ?></button>
                                                        </li>
                                            <?php } ?>
                                        </ul>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </li>
<?php } ?>