<?php if (!empty($product['product_description']) && trim($product['product_description']) != '') { ?>
    <div class="product-details">
        <h2 class="block-title"><?php echo Labels::getLabel('LBL_Description', $siteLangId); ?></h2>
        <div class="prod-desc"><?php echo CommonHelper::renderHtml($product['product_description'],true); ?></div>
    </div>
<?php } ?>

<?php if (!empty($product['selprodRentalTerms']) && trim($product['selprodRentalTerms']) != "") { ?>
    <div class="product-details">
        <h2 class="block-title"><?php echo Labels::getLabel('LBL_Rental_Terms', $siteLangId); ?></h2>
        <div class="prod-desc"><?php echo CommonHelper::renderHtml($product['selprodRentalTerms']); ?></div>
    </div>
<?php }  ?>

<?php $youtube_embed_code = UrlHelper::parseYoutubeUrl($product["product_youtube_video"]); ?>
<?php if (!empty($youtube_embed_code) && trim($youtube_embed_code) != '') { ?>
    <div class="product-details">
        <h2 class="block-title"> <?php echo Labels::getLabel('LBL_Video', $siteLangId); ?></h2>
        <div class="video-wrapper">
            <iframe width="100%" height="315" src="//www.youtube.com/embed/<?php echo $youtube_embed_code ?>" allowfullscreen></iframe>
        </div>
    </div>
<?php } ?>

<?php if (!empty($product['selprodComments'])) { ?>
    <div class="product-details">
        <h2><?php echo Labels::getLabel('LBL_Extra_comments', $siteLangId); ?></h2>
        <p class="product-details__text"><?php echo CommonHelper::displayNotApplicable($siteLangId, nl2br($product['selprodComments'])); ?>
    </div>
<?php } ?>