<?php if (isset($collection['blogs']) && count($collection['blogs']) > 0) { ?>
    <section class="section  section-home-blog" id="bog-layout-1_<?php echo $collection['collection_id']; ?>">
        <div class="container">
            <div class="row">
                <div class="col-lg-7 ">
                    <div class="home-blog--img">
                        <?php /* <a href="#"><img src="<?php echo CONF_WEBROOT_URL; ?>images/christmas-tree.png"></a> */ ?>
                        <img alt="<?php echo $collection['collection_name']; ?>" data-ratio="16:9"
                            src="<?php echo UrlHelper::generateFullUrl('Image', 'collectionReal', array($collection['collection_id'], $siteLangId, 'testimonial')); ?>">
                    </div>
                </div>
                <div class="col-lg-5 ">
                    <div class="js-ad--slider home-blog">
                        <?php foreach ($collection['blogs'] as $blog) { ?>
                            <div class="d-flex flex-column justify-content-between h-100">
                                <div class="home-blog-content">
                                    <div class="section-head">
                                        <div class="section-heading">
                                            <p>
                                                <?php echo $blog['post_author_name'] . ' ' . $blog['post_updated_on']; ?>
                                            </p>
                                            <h2>
                                                <?php
                                                $title = !empty($blog['post_title']) ? $blog['post_title'] : $blog['post_identifier'];
                                                echo mb_strimwidth($title, 0, applicationConstants::BLOG_TITLE_CHARACTER_LENGTH, '...');
                                                ?>
                                            </h2>
                                        </div>
                                    </div>
                                    <?php if (!empty($blog['post_short_description']) && trim($blog['post_short_description']) != "") { ?>
                                        <p class="home-blog--content">
                                            <?php echo FatUtility::decodeHtmlEntities($blog['post_short_description']); ?>
                                        </p>
                                    <?php } ?>
                                    <div class="link-more">
                                        <a class="link-arrow"
                                            href="<?php echo UrlHelper::generateUrl('Blog', 'postDetail', array($blog['post_id'])); ?>">
                                            <?php echo Labels::getLabel('LBL_VIEW_DETAIL', $siteLangId); ?>
                                        </a>
                                    </div>
                                </div>
                                <div class="home-blog-img-sm">
                                    <a
                                        href="<?php echo UrlHelper::generateUrl('Blog', 'postDetail', array($blog['post_id'])); ?>">
                                        <img src="<?php echo UrlHelper::generateUrl('Image', 'blogPostFront', array($blog['post_id'], $siteLangId, 'FEATURED')); ?>"
                                            alt="<?php echo (!empty($fileRow['afile_attribute_alt'])) ? $fileRow['afile_attribute_alt'] : $blog['post_title']; ?>"
                                            title="<?php echo (!empty($fileRow['afile_attribute_title'])) ? $fileRow['afile_attribute_title'] : $blog['post_title']; ?>">
                                    </a>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>