<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php if (isset($collection['categories']) && count($collection['categories'])) { ?>
<section class="section section-category" data-collection="collection-name">
    <div class="container">
        <div class="section-head">
            <div class="section-heading">
                <?php echo ($collection['collection_description'] != '') ? ' <p  class="section-heading-little">' . $collection['collection_description'] . '</p>' : ''; ?>
                <?php echo ($collection['collection_name'] != '') ? ' <h2>' . $collection['collection_name'] . '</h2>' : ''; ?>

                <?php //if ($collection['totCategories'] > $recordLimit) { 
                        ?>
            </div>
            <div class="section-head-action">
                <a class="link-arrow"
                    href="<?php echo UrlHelper::generateUrl('Collections', 'View', array($collection['collection_id'])); ?>">
                    <?php echo Labels::getLabel('LBL_Discover_more', $siteLangId); ?>
                </a>
            </div>
            <?php //}  
                    ?>
        </div>
        <div class="product-listing" data-view="4">
            <?php
                $itemCount = 0;
                foreach ($collection['categories'] as $category) {
                    if ($itemCount >= $recordLimit) {
                        break;
                    }
                    $itemCount++;
                    ?>
            <div class="category">
                <div class="category-head">
                    <a class="category-img"
                        href="<?php echo UrlHelper::generateUrl('Category', 'View', array($category['prodcat_id'])); ?>">
                        <img loading='lazy' data-ratio="4:3"
                            src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Category', 'icon', array($category['prodcat_id'], $siteLangId, 'HOME', applicationConstants::SCREEN_DESKTOP)), CONF_IMG_CACHE_TIME, '.jpg'); ?>"
                            alt="<?php echo (!empty($fileRow['afile_attribute_alt'])) ? $fileRow['afile_attribute_alt'] : $category['prodcat_name']; ?>"
                            title="<?php echo (!empty($fileRow['afile_attribute_title'])) ? $fileRow['afile_attribute_title'] : $category['prodcat_name']; ?>">
                    </a>
                </div>
                <div class="category-body">
                    <a class="category-title"
                        href="<?php echo UrlHelper::generateUrl('Category', 'View', array($category['prodcat_id'])); ?>">
                        <?php echo $category['prodcat_name']; ?>
                    </a>
                    <p>
                        <?php echo $category['recordCount']; ?>
                        <?php echo Labels::getLabel('LBL_Tools_&_Equipment', $siteLangId); ?>
                    </p>
                </div>
            </div>

            <?php } ?>
        </div>
    </div>
</section>
<?php } ?>