<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
if (isset($collection['categories']) && count($collection['categories']) > 0) { ?>
<section class="section" data-collection="collection-name"
    id="prod_category_lay4_<?php echo $collection['collection_id']; ?>">
    <div class="container">
        <div class="section-head section-head-center">
            <div class="section-heading">
                <p class="section-heading-little">
                    <?php echo $collection['collection_description']; ?>
                </p>
                <h2>
                    <?php echo $collection['collection_name']; ?>
                </h2>
            </div>
        </div>
        <div class="product-layout-4">
            <?php
                $index = 1;
                foreach ($collection['categories'] as $key => $category) {
                    if ($index > $recordLimit) {
                        break;
                    }
                    ?>
            <div class="product-grid">
                <div class="product-grid-head">
                    <a class="product-grid-img"
                        href="<?php echo UrlHelper::generateFullUrl('Category', 'view', array($key)); ?>">
                        <img loading='lazy' alt="<?php echo $category['prodcat_name']; ?>"
                            src="<?php echo UrlHelper::generateFullUrl('Image', 'CollectionCatTmage', array(intval($collection['collection_id']), $index, 'ORIGINAL', 0, $siteLangId)); ?>">
                    </a>
                </div>
                <div class="product-grid-body">
                    <div class="product-grid-data">
                        <h5>
                            <?php echo $category['prodcat_name']; ?>
                        </h5>

                        <a class="link-arrow"
                            href="<?php echo UrlHelper::generateFullUrl('Category', 'view', array($key)); ?>">
                            <?php echo Labels::getLabel('LBL_Discover_more', $siteLangId); ?>
                        </a>

                    </div>
                </div>
            </div>
            <?php
                    $index++;
                } ?>
        </div>
    </div>
</section>
<?php } ?>