<?php
if (isset($collection['faqs']) && count($collection['faqs']) > 0) {
    $faqCategories = array();
    foreach ($collection['faqs'] as $faq) {
        $faqCategories[$faq['faqcat_id']]['faqcat_name'] = $faq['faqcat_name'];
        $faqCategories[$faq['faqcat_id']]['faqs'][$faq['faq_id']] = $faq;
    }
    ?>
<section class="section section-faq" data-collection="collection-name">
    <div class="container container-narrow">
        <div class="section-head section-head-center">
            <div class="section-heading">
                <p class="section-heading-little">
                    <?php echo $collection['collection_description']; ?>
                </p>
                <h2>
                    <?php echo $collection['collection_name']; ?>
                </h2>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-4">
                <div class="faq--tab-verticle faqTabs--flat-js">
                    <ul>
                        <?php
                            $count = 0;
                            foreach ($faqCategories as $faqCatId => $faqCat) {
                                ?>
                        <li class="<?php echo ($count == 0) ? 'is-active' : ''; ?>">
                            <a href="#tb-<?php echo $faqCatId; ?>">
                                <?php echo $faqCat['faqcat_name']; ?>
                            </a>
                        </li>
                        <?php
                                $count++;
                            }
                            ?>
                    </ul>
                </div>
            </div>
            <div class="col-xl-8">
                <?php foreach ($faqCategories as $faqCatId => $faqCat) { ?>
                <div id="tb-<?php echo $faqCatId; ?>" class="faq tabs-content-home--js">
                    <?php
                            $i = 0;
                            foreach ($faqCat['faqs'] as $faqId => $faq) {
                                ?>
                    <div class="faq__component js-group <?php echo ($i == 0) ? 'is-active' : ''; ?>">
                        <div class="faq__component--head js-group-head">
                            <h4>
                                <?php echo $faq['faq_title']; ?>
                            </h4>
                        </div>
                        <div class="faq__component--body js-group-body">
							<?php if(!empty($faq['faq_content'])) { ?>
                            <p>
                                <?php echo FatUtility::decodeHtmlEntities($faq['faq_content']); ?>
                            </p>
							<?php } ?>
                        </div>
                    </div>
                    <?php
                                $i++;
                            }
                            ?>
                </div>
                <?php
                    }
                    /* if (count($faqCategories) > $recordLimit) {
                        ?>
                <div class="section-foot text-center">
                    <a class="btn btn-outline-primary btn-wide"
                        href="<?php echo UrlHelper::generateUrl('custom', 'faq'); ?>"><?php echo Labels::getLabel('LBL_View_All', $siteLangId); ?></a>
                </div>
                <?php } */ ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<script>
var $linkMoreText = '<?php echo Labels::getLabel('Lbl_SHOW_MORE', $siteLangId); ?>';
var $linkLessText = '<?php echo Labels::getLabel('Lbl_SHOW_LESS', $siteLangId); ?>';
</script>