<?php
if (isset($collection['testimonials']) && count($collection['testimonials']) > 0) { ?>
    <section class="section section-testimonial" data-collection="collection-name"
        id="section_<?php echo $collection['collection_id']; ?>">
        <div class="container">
            <div class="section-head">
                <div class="section-heading">
                    <p class="section-heading-little">
                        <?php echo $collection['collection_description']; ?>
                    </p>
                    <h2>
                        <?php echo $collection['collection_name']; ?>
                    </h2>
                </div>
                <div class="section-head-action">
                    <div class="slide-arrow arrowcontainer--<?php echo $collection['collection_id']; ?>">
                        <button class="slide--arrows arrow-prev slick-arrow"></button>
                        <button class="slide--arrows arrow-next slick-arrow"></button>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="testimonial--wrapper js-testimonial--slide"
                    id="slider-<?php echo $collection['collection_id']; ?>"
                    dir="<?php echo CommonHelper::getLayoutDirection(); ?>" data-slides="3,3,1,1" data-arrows="true"
                    data-swipe="true" data-swipeToSlide="true" data-customarrow="true"
                    data-arrowcontainer="arrowcontainer--<?php echo $collection['collection_id']; ?>">
                    <?php foreach ($collection['testimonials'] as $testimonial) { ?>
                        <div class="testimonials__item">
                            <div class="testimonial">
                                <div class="testimonial__head">
                                    <svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite.svg#quotes--test">
                                        </use>
                                    </svg>


                                    <p>
                                        <?php echo CommonHelper::truncateCharacters($testimonial['testimonial_text'], 250, '', '', true); ?>
                                        <?php if (strlen($testimonial['testimonial_text']) > 150) {
                                            echo '...';
                                        } ?>
                                    </p>
                                </div>
                                <div class="testimonial__body">
                                    <div class="testimonial--img">
                                        <img loading='lazy' alt="<?php echo $testimonial['testimonial_user_name']; ?>"
                                            src="<?php echo UrlHelper::generateUrl('Image', 'testimonial', array($testimonial['testimonial_id'], $siteLangId, 'THUMB')) . '?t=' . time(); ?>">
                                    </div>
                                    <div class="testimonial--detail">
                                        <h5>
                                            <?php echo $testimonial['testimonial_user_name']; ?>
                                        </h5>
                                        <span>
                                            <?php echo $testimonial['testimonial_author_city']; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>

        </div>
    </section>
<?php } ?>