<?php
defined('SYSTEM_INIT') or die('Invalid Usage');
$user_is_buyer = 0;
if (UserAuthentication::isUserLogged()) {
    $user_is_buyer = User::getAttributesById(UserAuthentication::getLoggedUserId(), 'user_is_buyer');
}
$rentalSecutityTotal = 0;
if ($user_is_buyer > 0 || (!UserAuthentication::isUserLogged())) {
    ?>
<button class="quick-nav-links button-cart" type="button" data-bs-toggle="offcanvas" data-bs-target="#side-cart"
    aria-controls="side-cart">
    <svg class="svg" width="16" height="16">
        <use
            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#bag">
        </use>
    </svg>
    <span class="cartQuantity">
        <?php echo (Cart::CART_MAX_DISPLAY_QTY < $totalCartItems) ? Cart::CART_MAX_DISPLAY_QTY . '+' : $totalCartItems; ?>
    </span>
    <span class="quick-nav-txt  hide-sm cart-quantity-txt">
        <?php echo Labels::getLabel('LBL_Item(s)', $siteLangId); ?>
    </span>
</button>
<div class="offcanvas offcanvas-end side-cart" tabindex="-1" id="side-cart" aria-labelledby="side-cartLabel">
    <div class="offcanvas-header side-cart_head">
        <h5 id="side-cartLabel">
            <?php echo Labels::getLabel('LBL_ITEMS', $siteLangId); ?>(
            <?php echo $totalCartItems; ?>)
        </h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <?php if ($totalCartItems > 0) { ?>
    <div class="offcanvas-body side-cart_body scroll scroll-y">
        <div class="cart-table">
            <?php
                    if (count($products)) {
                        foreach ($products as $product) {
                            if ($product['productFor'] == applicationConstants::PRODUCT_FOR_RENT) {
                                $rentalSecutityTotal += $product['sprodata_rental_security'] * $product['quantity'];
                            }
                            $productUrl = UrlHelper::generateUrl('Products', 'View', array($product['selprod_id']));
                            $shopUrl = UrlHelper::generateUrl('Shops', 'View', array($product['shop_id']));

                            $productName = isset($product['product_name']) ? $product['product_name'] : $product['selprod_title'];
                            if ($product['sellerProdType'] == SellerProduct::PRODUCT_TYPE_ADDON) {
                                $imageUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'addonProduct', array($product['selprod_id'], "THUMB", 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                                $productUrl = "empty";
                            } else {
                                $imageUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($product['product_id'], "EXTRA-SMALL", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                            } ?>

            <div class="cart-table-row <?php
                            echo (!$product['in_stock']) ? 'disabled' : '';
                            echo 'physical_product_tab-js';
                            ?>" data-cols="2">

                <div class="cart-table-col cart-table-col-1">
                    <div class="product-profile">

                        <?php if ($productUrl == "empty") { ?>
                        <button class="product-profile-thumbnail">
                            <span class="product-qty">
                                <?php echo $product['quantity']; ?>
                            </span>
                            <img src="<?php echo $imageUrl; ?>" alt="<?php echo $productName; ?>"
                                title="<?php echo $productName; ?>">
                        </button>
                        <?php } else { ?>
                        <a class="product-profile-thumbnail" href="<?php echo $productUrl; ?>">
                            <span class="product-qty">
                                <?php echo $product['quantity']; ?>
                            </span>
                            <img src="<?php echo $imageUrl; ?>" alt="<?php echo $productName; ?>"
                                title="<?php echo $productName; ?>">
                        </a>
                        <?php } ?>
                        <div class="product-profile-data">
                            <?php if ($productUrl == "empty") { ?>
                            <button class="title" title="<?php echo $productName; ?>">
                                <?php echo ($product['selprod_title']) ? $product['selprod_title'] : $productName; ?>
                            </button>
                            <?php } else { ?>
                            <a class="title" title="<?php echo $productName; ?>" href="<?php echo $productUrl; ?>">
                                <?php echo ($product['selprod_title']) ? $product['selprod_title'] : $productName; ?>
                            </a>
                            <?php } ?>
                            <?php if ($product['productFor'] == applicationConstants::PRODUCT_FOR_RENT) { ?>
                            <div class="product-price">
                                <span class="products-price-new">
                                    <?php echo CommonHelper::displayMoneyFormat(($product['theprice'] * $product['quantity'])); ?>
                                </span>
                            </div>
                            <?php } else { ?>
                            <div class="product-price">
                                <span class="products-price-new">
                                    <?php echo CommonHelper::displayMoneyFormat($product['theprice'] * $product['quantity']); ?>
                                </span>
                                 <?php if ($product['special_price_found'] && 0) { ?>
                                <span class="text--normal text--normal-secondary text-nowrap">
                                    <?php echo CommonHelper::showProductDiscountedText($product, $siteLangId); ?>
                                </span>
                                <?php } ?>
                            </div>
                            <?php } ?>
                            <?php if (isset($product['options']) && count($product['options'])) { ?>
                            <div class="options">
                                <?php
                                                    $count = 0;
                                                    foreach ($product['options'] as $option) {
                                                        echo ($count > 0) ? ' | ' : '';
                                                        echo $option['option_name'] . ':';
                                                        echo $option['optionvalue_name'];
                                                        $count++;
                                                    }
                                                    ?>
                            </div>
                            <?php } ?>
                            <?php if ($product['productFor'] == applicationConstants::PRODUCT_FOR_RENT) { ?>
                            <div class="dates">
                                <svg class="svg" width="16" height="16">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#calendar">
                                    </use>
                                </svg>
                                <span class="lable">
                                    <?php echo date('M d, Y H:i ', strtotime($product['rentalStartDate'])) . ' to ';
                                                        echo date('M d, Y H:i', strtotime($product['rentalEndDate'])); ?>
                                </span>
                            </div>
                            <?php } ?>
                            <!--  -->
                            <?php if ($product['productFor'] == applicationConstants::PRODUCT_FOR_RENT) { ?>
                            <div class="addons-products">
                                <ul>
                                    <li>
                                        <span class="lbl">
                                            <?php echo Labels::getLabel('LBL_Security_Amount', $siteLangId); ?>
                                        </span>
                                        <span class="price">
                                            <?php echo CommonHelper::displayMoneyFormat(($product['sprodata_rental_security'] * $product['quantity'])); ?>
                                        </span>
                                    </li>

                                    <?php if (isset($product['addonsData']) && !empty($product['addonsData'])) { ?>
                                    <?php foreach ($product['addonsData'] as $addKey => $addVal) { ?>
                                    <li>
                                        <button class="btn-close text-reset cross" type="button"
                                            onclick="cart.remove('<?php echo md5($addVal['key']); ?>')"
                                            title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId); ?>">

                                        </button>
                                        <span class="lbl">
                                            <?php echo $addVal['selprod_title']; ?>
                                        </span>
                                        <span class="price">
                                            <?php echo CommonHelper::displayMoneyFormat($addVal['theprice'] * $addVal['quantity']); ?>
                                        </span>
                                    </li>
                                    <?php } ?>
                                    <?php } ?>
                                </ul>
                            </div>
                            <?php } ?>
                            <!--  -->
                        </div>
                    </div>
                </div>
                <div class="cart-table-col cart-table-col-4">
                    <ul class="actions">
                        <li class="actions-item">
                            <button class="actions-link btn-remove" type="button"
                                onclick="cart.remove('<?php echo md5($product['key']); ?>')"
                                title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId); ?>">
                                <svg class="svg" width="18" height="18"
                                    title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId); ?>">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#remove">
                                    </use>
                                </svg>
                            </button>
                        </li>
                    </ul>
                </div>
            </div>
            <?php
                        }
                    } else {
                        echo Labels::getLabel('LBL_Your_cart_is_empty', $siteLangId);
                    }
                    ?>
        </div>
    </div>
    <div class="side-cart_foot">
        <ul class="cart-summary">
            <li class="cart-summary-item">
                <?php if ($cartSummary['cartType'] == applicationConstants::PRODUCT_FOR_SALE) { ?>
                <span class="label">
                    <?php echo Labels::getLabel('LBL_Sale_Amount', $siteLangId); ?>
                </span>
                <?php } else { ?>
                <span class="label">
                    <?php echo Labels::getLabel('LBL_Rental_Amount', $siteLangId); ?>
                </span>
                <?php } ?>
                <span class="value">
                    <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartTotal']); ?>
                </span>
            </li>
            <?php if ($rentalSecutityTotal > 0) { ?>
            <li class="cart-summary-item">
                <span class="label">
                    <?php echo Labels::getLabel('LBL_Rental_Security', $siteLangId); ?>
                </span>
                <span class="value">
                    <?php echo CommonHelper::displayMoneyFormat($rentalSecutityTotal); ?>
                </span>
            </li>
            <?php } ?>

            <?php if ($cartSummary['addonTotalAmount'] > 0) { ?>
            <li class="cart-summary-item">
                <span class="label">
                    <?php echo Labels::getLabel('LBL_Addons_Total_Amount', $siteLangId); ?>
                </span>
                <span class="value">
                    <?php echo CommonHelper::displayMoneyFormat($cartSummary['addonTotalAmount']); ?>
                </span>
            </li>
            <?php } ?>
            <?php if (0 < $cartSummary['cartVolumeDiscount']) { ?>
            <li class="cart-summary-item">
                <span class="label">
                    <?php echo Labels::getLabel('LBL_Volume_Discount', $siteLangId); ?>
                </span>
                <span class="value"> -
                    <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartVolumeDiscount']); ?>
                </span>
            </li>
            <?php } ?>
            <?php if (0 < $cartSummary['cartDurationDiscount']) { ?>
            <li class="cart-summary-item">
                <span class="label">
                    <?php echo Labels::getLabel('LBL_Duration_Discount', $siteLangId); ?>
                </span>
                <span class="value"> -
                    <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartDurationDiscount']); ?>
                </span>
            </li>
            <?php } ?>

            <?php
                    if ($product['productFor'] == applicationConstants::PRODUCT_FOR_RENT) {
                        $netChargeAmt = $cartSummary['cartTotal'] + $cartSummary['addonTotalAmount'] + $rentalSecutityTotal - ((0 < $cartSummary['cartDurationDiscount']) ? $cartSummary['cartDurationDiscount'] : 0);
                    } else {
                        $netChargeAmt = $cartSummary['cartTotal'] + $cartSummary['addonTotalAmount'] + $rentalSecutityTotal - ((0 < $cartSummary['cartVolumeDiscount']) ? $cartSummary['cartVolumeDiscount'] : 0);
                    }
                    ?>
            <li class="cart-summary-item highlighted">
                <span class="label">
                    <?php echo Labels::getLabel('LBL_Net_Payable', $siteLangId); ?>
                </span>
                <span class="value">
                    <?php echo CommonHelper::displayMoneyFormat($netChargeAmt); ?>
                </span>
            </li>
        </ul>
        <div class="buttons-group">
            <button type="button" class="btn btn-outline-gray" onclick="cart.clear();">
                <?php echo Labels::getLabel('LBL_CLEAR_CART', $siteLangId); ?>
            </button>
            <a class="btn btn-brand" href="<?php echo UrlHelper::generateUrl('cart'); ?>">
                <?php echo Labels::getLabel('LBL_Go_To_Cart', $siteLangId); ?>
            </a>
        </div>
    </div>
    <?php } else { ?>
    <div class="block-empty m-auto text-center">
        <img class="block__img" loading='lazy' src="<?php echo CONF_WEBROOT_URL; ?>images/illustrations/empty-cart.svg"
            width="200" alt="<?php echo Labels::getLabel('LBL_No_Record_Found', $siteLangId); ?>">
        <h4>
            <?php echo Labels::getLabel('LBL_Your_Shopping_Bag_is_Empty', $siteLangId); ?>
        </h4>
    </div>
    <?php } ?>
</div>
<?php } ?>

<script>
$(document).ready(function() {
    $("#offcanvas-cart").html($("#cartSummary #side-cart"));
    $('body').find('*[data-trigger-cart]').click(function() {
        var targetElmId = $(this).data('trigger-cart');
        var elmToggleClass = targetElmId + '--on';
        if ($('body').hasClass(elmToggleClass)) {
            $('body').removeClass(elmToggleClass);
        } else {
            $('body').addClass(elmToggleClass);
        }
    });

    $('body').find('*[data-bs-target-close-cart]').click(function() {
        var targetElmId = $(this).data('target-close-cart');
        $('body').toggleClass(targetElmId + '--on');
    });

    $('body').mouseup(function(event) {
        if ($(event.target).data('triggerCart') != '' && typeof $(event.target).data('triggerCart') !==
            typeof undefined) {
            event.preventDefault();
            return;
        }

        $('body').find('*[data-close-on-click-outside-cart]').each(function(idx, elm) {
            var slctr = $(elm);
            if (!slctr.is(event.target) && !$.contains(slctr[0], event.target)) {
                $('body').removeClass(slctr.data('close-on-click-outside-cart') + '--on');
            }
        });

        $('body').find('*[data-bs-target-close-cart]').click(function() {
            var targetElmId = $(this).data('target-close-cart');
            $('body').toggleClass(targetElmId + '--on');
        });

        $('body').mouseup(function(event) {
            if ($(event.target).data('triggerCart') != '' && typeof $(event.target).data(
                    'triggerCart') !== typeof undefined) {
                event.preventDefault();
                return;
            }

            $('body').find('*[data-close-on-click-outside-cart]').each(function(idx, elm) {
                var slctr = $(elm);
                if (!slctr.is(event.target) && !$.contains(slctr[0], event.target)) {
                    $('body').removeClass(slctr.data('close-on-click-outside-cart') +
                        '--on');
                }
            });
        });
    });
});
</script>