<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
if (!empty($products)) { ?>
    <div class="container">
        <div class="section-head">
            <div class="section-heading">
                <p class="section-heading-little">
                    <?php echo $subheading; ?>
                </p>
                <h2>
                    <?php echo $heading; ?>
                </h2>
            </div>

            <?php if (count($products) > 5) { ?>
                <div class="section-head-action">
                    <div class="slide-arrow arrowcontainer--<?php echo (isset($sectionId)) ? $sectionId : 1; ?>">
                        <button class="slide--arrows arrow-prev" aria-label="prev"></button>
                        <button class="slide--arrows arrow-next" aria-label="next"></button>
                    </div>
                </div>
            <?php } ?>
        </div>
        <div class="section-body">
            <div class="slider-wrapper <?php echo (count($products) > 0) ? "js-carousel" : ""; ?>" data-slides="5,3,2,2,1"
                data-infinite="true" data-arrows="true" data-slickdots="false" data-swipe="true"
                dir="<?php echo CommonHelper::getLayoutDirection(); ?>"
                data-arrowcontainer="arrowcontainer--<?php echo (isset($sectionId)) ? $sectionId : 1; ?>"
                data-customarrow="true" id="slider_<?php echo (isset($sectionId)) ? $sectionId : 1; ?>">

                <?php
                foreach ($products as $rproduct) {
                    $dataToSend = [
                        'product' => $rproduct,
                        'siteLangId' => $siteLangId,
                        'compProdCount' => (isset($compProdCount)) ? $compProdCount : 0,
                        'prodInCompList' => (isset($prodInCompList)) ? $prodInCompList : 0,
                        'comparedProdSpecCatId' => (isset($comparedProdSpecCatId)) ? $comparedProdSpecCatId : 0,
                    ];
                    ?>
                    <div class="js-carousel-item">
                        <?php echo $this->includeTemplate('_partial/collection/product-listing-tile-layout-2.php', $dataToSend); ?>
                    </div>
                <?php }
                ?>

            </div>
        </div>
    </div>
<?php } ?>