import nodeSass from "node-sass";
import gulp from "gulp";
const { src, dest, watch, series } = gulp;
import sourcemaps from "gulp-sourcemaps";
import gulpSass from "gulp-sass";
import autoPrefixer from "gulp-autoprefixer";
import * as sass from "sass";
const scss = gulpSass(sass);
scss.compiler = nodeSass;

// Tasks
function base() {
    return src("./application/views/default/scss/*.scss")
        .pipe(sourcemaps.init({ loadMaps: true }))
        .pipe(scss({ outputStyle: "compressed" }))
        .pipe(autoPrefixer())
        .pipe(sourcemaps.write("."))
        .pipe(dest("./application/views/default/css"));
}

function fashion() {
    return src("./application/views/fashion/scss/*.scss")
        .pipe(sourcemaps.init({ loadMaps: true }))
        .pipe(scss({ outputStyle: "compressed" }))
        .pipe(autoPrefixer())
        .pipe(sourcemaps.write("."))
        .pipe(dest("./application/views/fashion/css"));
}

function heavy_equipment() {
    return src("./application/views/heavy_equipment/scss/*.scss")
        .pipe(sourcemaps.init({ loadMaps: true }))
        .pipe(scss({ outputStyle: "compressed" }))
        .pipe(autoPrefixer())
        .pipe(sourcemaps.write("."))
        .pipe(dest("./application/views/heavy_equipment/css"));
}

function automobile() {
    return src("./application/views/automobile/scss/*.scss")
        .pipe(sourcemaps.init({ loadMaps: true }))
        .pipe(scss({ outputStyle: "compressed" }))
        .pipe(autoPrefixer())
        .pipe(sourcemaps.write("."))
        .pipe(dest("./application/views/automobile/css"));
}

function dashboard() {
    return src("./application/views/default/dashboard/scss/*.scss")
        .pipe(sourcemaps.init({ loadMaps: true }))
        .pipe(scss({ outputStyle: "compressed" }))
        .pipe(autoPrefixer())
        .pipe(sourcemaps.write("."))
        .pipe(dest("./application/views/default/dashboard/css"));
}

function admin() {
    return src("./admin-application/views/default/scss/*.scss")
        .pipe(sourcemaps.init({ loadMaps: true }))
        .pipe(scss({ outputStyle: "compressed" }))
        .pipe(autoPrefixer())
        .pipe(sourcemaps.write("."))
        .pipe(dest("./admin-application/views/default/css"));
}

//Watch minifyjs
function minifyjs() {
    return src("./application/views/default/common-js-src/*.js", {
        allowEmpty: true,
    })
        .pipe(minify({ noSource: true }))
        .pipe(concat("myapp.js"))
        .pipe(dest("./application/views/default/common-js"));
}

// Watch files
function watchFiles() {
    // Watch SCSS changes
    watch(["./application/views/default/scss"], base);
    watch(["./application/views/fashion/scss"], fashion);
    watch(["./application/views/heavy_equipment/scss"], heavy_equipment);
    watch(["./application/views/automobile/scss"], automobile);
    watch(["./application/views/default/dashboard/scss"], dashboard);
    watch(["./admin-application/views/default/scss"], admin);
    watch(["./application/views/default/common-js-src"], minifyjs);
}

export default series(
    base,
    fashion,
    heavy_equipment,
    automobile,
    dashboard,
    admin,
    minifyjs
);

export { watchFiles as watch };
